/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.MarkUnreadChatAlt: ImageVector
    get() {
        if (_markUnreadChatAlt != null) {
            return _markUnreadChatAlt!!
        }
        _markUnreadChatAlt = materialIcon(name = "Outlined.MarkUnreadChatAlt") {
            materialPath {
                moveTo(20.0f, 16.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(10.1f)
                curveToRelative(-0.08f, -0.39f, -0.18f, -1.11f, 0.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(18.0f)
                lineToRelative(4.0f, -4.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.98f)
                curveToRelative(-0.58f, 0.44f, -1.26f, 0.77f, -2.0f, 0.92f)
                verticalLineTo(16.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                moveToRelative(-3.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, 6.0f, 0.0f)
                arcToRelative(3.0f, 3.0f, 0.0f, true, true, -6.0f, 0.0f)
            }
            materialPath {
                moveTo(6.0f, 12.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-8.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 9.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-12.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 8.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(7.9f)
                curveToRelative(-1.21f, -0.25f, -2.25f, -0.95f, -2.97f, -1.9f)
                horizontalLineTo(6.0f)
                verticalLineTo(8.0f)
                close()
            }
        }
        return _markUnreadChatAlt!!
    }

private var _markUnreadChatAlt: ImageVector? = null
