/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FilterTiltShift: ImageVector
    get() {
        if (_filterTiltShift != null) {
            return _filterTiltShift!!
        }
        _filterTiltShift = materialIcon(name = "Outlined.FilterTiltShift") {
            materialPath {
                moveTo(11.0f, 4.07f)
                lineTo(11.0f, 2.05f)
                curveToRelative(-2.01f, 0.2f, -3.84f, 1.0f, -5.32f, 2.21f)
                lineTo(7.1f, 5.69f)
                curveToRelative(1.11f, -0.86f, 2.44f, -1.44f, 3.9f, -1.62f)
                close()
                moveTo(18.32f, 4.26f)
                curveTo(16.84f, 3.05f, 15.01f, 2.25f, 13.0f, 2.05f)
                verticalLineToRelative(2.02f)
                curveToRelative(1.46f, 0.18f, 2.79f, 0.76f, 3.9f, 1.62f)
                lineToRelative(1.42f, -1.43f)
                close()
                moveTo(19.93f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveToRelative(-0.2f, -2.01f, -1.0f, -3.84f, -2.21f, -5.32f)
                lineTo(18.31f, 7.1f)
                curveToRelative(0.86f, 1.11f, 1.44f, 2.44f, 1.62f, 3.9f)
                close()
                moveTo(5.69f, 7.1f)
                lineTo(4.26f, 5.68f)
                curveTo(3.05f, 7.16f, 2.25f, 8.99f, 2.05f, 11.0f)
                horizontalLineToRelative(2.02f)
                curveToRelative(0.18f, -1.46f, 0.76f, -2.79f, 1.62f, -3.9f)
                close()
                moveTo(4.07f, 13.0f)
                lineTo(2.05f, 13.0f)
                curveToRelative(0.2f, 2.01f, 1.0f, 3.84f, 2.21f, 5.32f)
                lineToRelative(1.43f, -1.43f)
                curveToRelative(-0.86f, -1.1f, -1.44f, -2.43f, -1.62f, -3.89f)
                close()
                moveTo(15.0f, 12.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                close()
                moveTo(18.31f, 16.9f)
                lineToRelative(1.43f, 1.43f)
                curveToRelative(1.21f, -1.48f, 2.01f, -3.32f, 2.21f, -5.32f)
                horizontalLineToRelative(-2.02f)
                curveToRelative(-0.18f, 1.45f, -0.76f, 2.78f, -1.62f, 3.89f)
                close()
                moveTo(13.0f, 19.93f)
                verticalLineToRelative(2.02f)
                curveToRelative(2.01f, -0.2f, 3.84f, -1.0f, 5.32f, -2.21f)
                lineToRelative(-1.43f, -1.43f)
                curveToRelative(-1.1f, 0.86f, -2.43f, 1.44f, -3.89f, 1.62f)
                close()
                moveTo(5.68f, 19.74f)
                curveTo(7.16f, 20.95f, 9.0f, 21.75f, 11.0f, 21.95f)
                verticalLineToRelative(-2.02f)
                curveToRelative(-1.46f, -0.18f, -2.79f, -0.76f, -3.9f, -1.62f)
                lineToRelative(-1.42f, 1.43f)
                close()
            }
        }
        return _filterTiltShift!!
    }

private var _filterTiltShift: ImageVector? = null
