/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SportsVolleyball: ImageVector
    get() {
        if (_sportsVolleyball != null) {
            return _sportsVolleyball!!
        }
        _sportsVolleyball = materialIcon(name = "TwoTone.SportsVolleyball") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 6.73f)
                curveTo(4.76f, 8.14f, 4.0f, 9.98f, 4.0f, 12.0f)
                curveToRelative(0.0f, 1.1f, 0.23f, 2.14f, 0.63f, 3.1f)
                lineTo(6.0f, 14.31f)
                verticalLineTo(6.73f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.0f, 4.08f)
                curveToRelative(-0.25f, 0.06f, -1.98f, 0.42f, -3.0f, 1.01f)
                verticalLineToRelative(8.07f)
                lineToRelative(3.0f, -1.73f)
                verticalLineTo(4.08f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 4.07f)
                verticalLineToRelative(1.58f)
                lineToRelative(6.54f, 3.79f)
                curveTo(18.57f, 6.59f, 16.07f, 4.45f, 13.0f, 4.07f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 13.15f)
                lineToRelative(-6.36f, 3.67f)
                curveToRelative(0.64f, 0.85f, 1.46f, 1.55f, 2.38f, 2.09f)
                lineTo(15.0f, 14.89f)
                lineTo(12.0f, 13.15f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 7.96f)
                verticalLineToRelative(3.46f)
                lineToRelative(6.37f, 3.68f)
                curveToRelative(0.4f, -0.95f, 0.63f, -1.99f, 0.63f, -3.09f)
                lineTo(13.0f, 7.96f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.42f, 19.84f)
                curveTo(10.93f, 19.94f, 11.46f, 20.0f, 12.0f, 20.0f)
                curveToRelative(2.6f, 0.0f, 4.9f, -1.25f, 6.36f, -3.17f)
                lineTo(17.0f, 16.04f)
                lineTo(10.42f, 19.84f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(13.0f, 4.07f)
                curveToRelative(3.07f, 0.38f, 5.57f, 2.52f, 6.54f, 5.36f)
                lineTo(13.0f, 5.65f)
                verticalLineTo(4.07f)
                close()
                moveTo(8.0f, 5.08f)
                curveToRelative(1.02f, -0.59f, 2.75f, -0.95f, 3.0f, -1.01f)
                verticalLineToRelative(7.35f)
                lineToRelative(-3.0f, 1.73f)
                verticalLineTo(5.08f)
                close()
                moveTo(4.63f, 15.1f)
                curveTo(4.23f, 14.14f, 4.0f, 13.1f, 4.0f, 12.0f)
                curveToRelative(0.0f, -2.02f, 0.76f, -3.86f, 2.0f, -5.27f)
                verticalLineToRelative(7.58f)
                lineTo(4.63f, 15.1f)
                close()
                moveTo(5.64f, 16.83f)
                lineTo(12.0f, 13.15f)
                lineToRelative(3.0f, 1.73f)
                lineToRelative(-6.98f, 4.03f)
                curveTo(7.09f, 18.38f, 6.28f, 17.68f, 5.64f, 16.83f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-0.54f, 0.0f, -1.07f, -0.06f, -1.58f, -0.16f)
                lineToRelative(6.58f, -3.8f)
                lineToRelative(1.36f, 0.78f)
                curveTo(16.9f, 18.75f, 14.6f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(13.0f, 11.42f)
                verticalLineTo(7.96f)
                lineToRelative(7.0f, 4.05f)
                curveToRelative(0.0f, 1.1f, -0.23f, 2.14f, -0.63f, 3.09f)
                lineTo(13.0f, 11.42f)
                close()
            }
        }
        return _sportsVolleyball!!
    }

private var _sportsVolleyball: ImageVector? = null
