/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DirectionsBoat: ImageVector
    get() {
        if (_directionsBoat != null) {
            return _directionsBoat!!
        }
        _directionsBoat = materialIcon(name = "TwoTone.DirectionsBoat") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.49f, 15.68f)
                lineTo(8.0f, 13.96f)
                lineToRelative(1.51f, 1.72f)
                curveToRelative(0.34f, 0.4f, 1.28f, 1.32f, 2.49f, 1.32f)
                curveToRelative(1.21f, 0.0f, 2.15f, -0.92f, 2.49f, -1.32f)
                lineTo(16.0f, 13.96f)
                lineToRelative(1.51f, 1.72f)
                curveToRelative(0.2f, 0.23f, 0.6f, 0.64f, 1.14f, 0.94f)
                lineToRelative(1.12f, -3.97f)
                lineToRelative(-2.39f, -0.78f)
                lineTo(12.0f, 10.11f)
                lineToRelative(-5.38f, 1.77f)
                lineToRelative(-2.4f, 0.79f)
                lineToRelative(1.13f, 3.96f)
                curveToRelative(0.55f, -0.31f, 0.94f, -0.72f, 1.14f, -0.95f)
                close()
                moveTo(11.0f, 3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(3.95f, 19.0f)
                lineTo(4.0f, 19.0f)
                curveToRelative(1.6f, 0.0f, 3.02f, -0.88f, 4.0f, -2.0f)
                curveToRelative(0.98f, 1.12f, 2.4f, 2.0f, 4.0f, 2.0f)
                reflectiveCurveToRelative(3.02f, -0.88f, 4.0f, -2.0f)
                curveToRelative(0.98f, 1.12f, 2.4f, 2.0f, 4.0f, 2.0f)
                horizontalLineToRelative(0.05f)
                lineToRelative(1.89f, -6.68f)
                curveToRelative(0.08f, -0.26f, 0.06f, -0.54f, -0.06f, -0.78f)
                reflectiveCurveToRelative(-0.34f, -0.42f, -0.6f, -0.5f)
                lineTo(20.0f, 10.62f)
                lineTo(20.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-3.0f)
                lineTo(15.0f, 1.0f)
                lineTo(9.0f, 1.0f)
                verticalLineToRelative(3.0f)
                lineTo(6.0f, 4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.62f)
                lineToRelative(-1.29f, 0.42f)
                curveToRelative(-0.26f, 0.08f, -0.48f, 0.26f, -0.6f, 0.5f)
                reflectiveCurveToRelative(-0.15f, 0.52f, -0.06f, 0.78f)
                lineTo(3.95f, 19.0f)
                close()
                moveTo(11.0f, 3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(11.0f, 3.0f)
                close()
                moveTo(6.0f, 6.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(3.97f)
                lineTo(12.0f, 8.0f)
                lineTo(6.0f, 9.97f)
                lineTo(6.0f, 6.0f)
                close()
                moveTo(6.62f, 11.87f)
                lineTo(12.0f, 10.11f)
                lineToRelative(5.38f, 1.77f)
                lineToRelative(2.39f, 0.78f)
                lineToRelative(-1.12f, 3.97f)
                curveToRelative(-0.54f, -0.3f, -0.94f, -0.71f, -1.14f, -0.94f)
                lineTo(16.0f, 13.96f)
                lineToRelative(-1.51f, 1.72f)
                curveToRelative(-0.34f, 0.4f, -1.28f, 1.32f, -2.49f, 1.32f)
                curveToRelative(-1.21f, 0.0f, -2.15f, -0.92f, -2.49f, -1.32f)
                lineTo(8.0f, 13.96f)
                lineToRelative(-1.51f, 1.72f)
                curveToRelative(-0.2f, 0.23f, -0.6f, 0.63f, -1.14f, 0.93f)
                lineToRelative(-1.13f, -3.96f)
                lineToRelative(2.4f, -0.78f)
                close()
                moveTo(8.0f, 22.01f)
                curveToRelative(1.26f, 0.64f, 2.63f, 0.97f, 4.0f, 0.97f)
                reflectiveCurveToRelative(2.74f, -0.32f, 4.0f, -0.97f)
                curveToRelative(1.26f, 0.65f, 2.62f, 0.99f, 4.0f, 0.99f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-1.39f, 0.0f, -2.78f, -0.47f, -4.0f, -1.32f)
                curveToRelative(-1.22f, 0.85f, -2.61f, 1.28f, -4.0f, 1.28f)
                reflectiveCurveToRelative(-2.78f, -0.43f, -4.0f, -1.28f)
                curveTo(6.78f, 20.53f, 5.39f, 21.0f, 4.0f, 21.0f)
                lineTo(2.0f, 21.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.38f, 0.0f, 2.74f, -0.35f, 4.0f, -0.99f)
                close()
            }
        }
        return _directionsBoat!!
    }

private var _directionsBoat: ImageVector? = null
