/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SwipeVertical: ImageVector
    get() {
        if (_swipeVertical != null) {
            return _swipeVertical!!
        }
        _swipeVertical = materialIcon(name = "Sharp.SwipeVertical") {
            materialPath {
                moveTo(1.0f, 3.5f)
                horizontalLineToRelative(2.02f)
                curveTo(1.13f, 5.82f, 0.0f, 8.78f, 0.0f, 12.0f)
                reflectiveCurveToRelative(1.13f, 6.18f, 3.02f, 8.5f)
                horizontalLineTo(1.0f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(4.5f)
                verticalLineToRelative(2.91f)
                curveToRelative(-1.86f, -2.11f, -3.0f, -4.88f, -3.0f, -7.91f)
                reflectiveCurveToRelative(1.14f, -5.79f, 3.0f, -7.91f)
                verticalLineTo(7.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(2.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(3.5f)
                close()
                moveTo(21.71f, 11.18f)
                lineToRelative(2.09f, 7.39f)
                lineToRelative(-8.23f, 3.65f)
                lineToRelative(-6.84f, -2.85f)
                lineToRelative(0.61f, -1.62f)
                lineToRelative(3.8f, -0.75f)
                lineTo(8.79f, 7.17f)
                curveToRelative(-0.34f, -0.76f, 0.0f, -1.64f, 0.76f, -1.98f)
                curveToRelative(0.76f, -0.34f, 1.64f, 0.0f, 1.98f, 0.76f)
                lineToRelative(2.43f, 5.49f)
                lineToRelative(1.26f, -0.56f)
                lineTo(21.71f, 11.18f)
                close()
            }
        }
        return _swipeVertical!!
    }

private var _swipeVertical: ImageVector? = null
