/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoMeetingRoom: ImageVector
    get() {
        if (_noMeetingRoom != null) {
            return _noMeetingRoom!!
        }
        _noMeetingRoom = materialIcon(name = "Sharp.NoMeetingRoom") {
            materialPath {
                moveTo(14.0f, 6.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(7.88f)
                lineToRelative(2.0f, 2.0f)
                lineTo(19.0f, 4.0f)
                horizontalLineToRelative(-5.0f)
                lineTo(14.0f, 3.0f)
                lineTo(6.12f, 3.0f)
                lineTo(14.0f, 10.88f)
                close()
                moveTo(12.0f, 11.71f)
                lineTo(12.0f, 13.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.29f)
                lineTo(2.41f, 2.13f)
                lineTo(1.0f, 3.54f)
                lineToRelative(4.0f, 4.0f)
                lineTo(5.0f, 19.0f)
                lineTo(3.0f, 19.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(-4.46f)
                lineTo(20.46f, 23.0f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _noMeetingRoom!!
    }

private var _noMeetingRoom: ImageVector? = null
