/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.Label",
    ReplaceWith( "Icons.AutoMirrored.Sharp.Label",
            "androidx.compose.material.icons.automirrored.sharp.Label"),
)
public val Icons.Sharp.Label: ImageVector
    get() {
        if (_label != null) {
            return _label!!
        }
        _label = materialIcon(name = "Sharp.Label") {
            materialPath {
                moveTo(17.03f, 5.0f)
                lineTo(3.0f, 5.01f)
                verticalLineToRelative(13.98f)
                lineToRelative(14.03f, 0.01f)
                lineTo(22.0f, 12.0f)
                lineToRelative(-4.97f, -7.0f)
                close()
            }
        }
        return _label!!
    }

private var _label: ImageVector? = null
