/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector
import kotlin.Deprecated

@Deprecated(
    "Use the AutoMirrored version at Icons.AutoMirrored.Sharp.ArrowBackIos",
    ReplaceWith( "Icons.AutoMirrored.Sharp.ArrowBackIos",
            "androidx.compose.material.icons.automirrored.sharp.ArrowBackIos"),
)
public val Icons.Sharp.ArrowBackIos: ImageVector
    get() {
        if (_arrowBackIos != null) {
            return _arrowBackIos!!
        }
        _arrowBackIos = materialIcon(name = "Sharp.ArrowBackIos") {
            materialPath {
                moveTo(17.51f, 3.87f)
                lineTo(15.73f, 2.1f)
                lineTo(5.84f, 12.0f)
                lineToRelative(9.9f, 9.9f)
                lineToRelative(1.77f, -1.77f)
                lineTo(9.38f, 12.0f)
                lineToRelative(8.13f, -8.13f)
                close()
            }
        }
        return _arrowBackIos!!
    }

private var _arrowBackIos: ImageVector? = null
