/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NoCell: ImageVector
    get() {
        if (_noCell != null) {
            return _noCell!!
        }
        _noCell = materialIcon(name = "Rounded.NoCell") {
            materialPath {
                moveTo(8.83f, 6.0f)
                lineToRelative(-3.7f, -3.7f)
                curveTo(5.42f, 1.55f, 6.15f, 1.0f, 7.0f, 1.0f)
                lineToRelative(10.0f, 0.01f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.89f, 2.0f, 1.99f)
                verticalLineToRelative(13.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(8.83f)
                close()
                moveTo(20.49f, 21.9f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                lineToRelative(-0.2f, -0.2f)
                curveTo(18.58f, 22.45f, 17.85f, 23.0f, 17.0f, 23.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(7.83f)
                lineToRelative(-2.9f, -2.9f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(16.97f, 16.97f)
                curveTo(20.88f, 20.88f, 20.88f, 21.51f, 20.49f, 21.9f)
                close()
                moveTo(15.17f, 18.0f)
                lineTo(7.0f, 9.83f)
                verticalLineTo(18.0f)
                horizontalLineTo(15.17f)
                close()
            }
        }
        return _noCell!!
    }

private var _noCell: ImageVector? = null
