/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NetworkPing: ImageVector
    get() {
        if (_networkPing != null) {
            return _networkPing!!
        }
        _networkPing = materialIcon(name = "Rounded.NetworkPing") {
            materialPath {
                moveTo(2.71f, 6.79f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(10.5f, 16.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-5.5f)
                lineToRelative(5.15f, -5.15f)
                curveTo(18.91f, 10.95f, 19.2f, 11.0f, 19.5f, 11.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                reflectiveCurveTo(20.88f, 6.0f, 19.5f, 6.0f)
                reflectiveCurveTo(17.0f, 7.12f, 17.0f, 8.5f)
                curveToRelative(0.0f, 0.35f, 0.07f, 0.67f, 0.2f, 0.97f)
                lineToRelative(-5.2f, 5.2f)
                lineTo(4.12f, 6.79f)
                curveTo(3.73f, 6.4f, 3.1f, 6.4f, 2.71f, 6.79f)
                close()
            }
        }
        return _networkPing!!
    }

private var _networkPing: ImageVector? = null
