/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Eco: ImageVector
    get() {
        if (_eco != null) {
            return _eco!!
        }
        _eco = materialIcon(name = "Rounded.Eco") {
            materialPath {
                moveTo(19.95f, 5.97f)
                curveToRelative(-0.05f, -1.04f, -0.89f, -1.88f, -1.92f, -1.92f)
                curveTo(17.33f, 4.02f, 16.66f, 4.0f, 16.01f, 4.0f)
                curveTo(10.98f, 4.0f, 7.49f, 4.97f, 5.55f, 6.91f)
                curveToRelative(-3.68f, 3.68f, -3.15f, 8.9f, 0.09f, 11.9f)
                curveToRelative(0.01f, 0.0f, 0.01f, 0.0f, 0.01f, 0.0f)
                curveToRelative(1.51f, -4.22f, 4.52f, -7.16f, 7.67f, -8.8f)
                curveToRelative(-0.21f, 0.18f, -4.7f, 3.58f, -5.51f, 10.25f)
                curveToRelative(1.05f, 0.48f, 2.2f, 0.75f, 3.36f, 0.75f)
                curveToRelative(2.05f, 0.0f, 4.16f, -0.8f, 5.92f, -2.55f)
                curveTo(19.28f, 16.26f, 20.23f, 12.1f, 19.95f, 5.97f)
                close()
            }
        }
        return _eco!!
    }

private var _eco: ImageVector? = null
