/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ControlPointDuplicate: ImageVector
    get() {
        if (_controlPointDuplicate != null) {
            return _controlPointDuplicate!!
        }
        _controlPointDuplicate = materialIcon(name = "Rounded.ControlPointDuplicate") {
            materialPath {
                moveTo(15.0f, 8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveToRelative(-0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(16.0f, 9.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                close()
                moveTo(2.0f, 12.0f)
                curveToRelative(0.0f, -2.58f, 1.4f, -4.83f, 3.48f, -6.04f)
                curveToRelative(0.32f, -0.19f, 0.53f, -0.51f, 0.53f, -0.88f)
                curveToRelative(0.0f, -0.77f, -0.84f, -1.25f, -1.51f, -0.86f)
                curveTo(1.82f, 5.78f, 0.0f, 8.68f, 0.0f, 12.0f)
                reflectiveCurveToRelative(1.82f, 6.22f, 4.5f, 7.78f)
                curveToRelative(0.67f, 0.39f, 1.51f, -0.09f, 1.51f, -0.86f)
                curveToRelative(0.0f, -0.37f, -0.21f, -0.69f, -0.53f, -0.88f)
                curveTo(3.4f, 16.83f, 2.0f, 14.58f, 2.0f, 12.0f)
                close()
                moveTo(15.0f, 3.0f)
                curveToRelative(-4.96f, 0.0f, -9.0f, 4.04f, -9.0f, 9.0f)
                reflectiveCurveToRelative(4.04f, 9.0f, 9.0f, 9.0f)
                reflectiveCurveToRelative(9.0f, -4.04f, 9.0f, -9.0f)
                reflectiveCurveToRelative(-4.04f, -9.0f, -9.0f, -9.0f)
                close()
                moveTo(15.0f, 19.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, -3.14f, -7.0f, -7.0f)
                reflectiveCurveToRelative(3.14f, -7.0f, 7.0f, -7.0f)
                reflectiveCurveToRelative(7.0f, 3.14f, 7.0f, 7.0f)
                reflectiveCurveToRelative(-3.14f, 7.0f, -7.0f, 7.0f)
                close()
            }
        }
        return _controlPointDuplicate!!
    }

private var _controlPointDuplicate: ImageVector? = null
