/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Calculate: ImageVector
    get() {
        if (_calculate != null) {
            return _calculate!!
        }
        _calculate = materialIcon(name = "Rounded.Calculate") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(13.56f, 6.53f)
                lineTo(13.56f, 6.53f)
                curveToRelative(0.29f, -0.29f, 0.77f, -0.29f, 1.06f, 0.0f)
                lineToRelative(0.88f, 0.88f)
                lineToRelative(0.88f, -0.88f)
                curveToRelative(0.29f, -0.29f, 0.77f, -0.29f, 1.06f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.29f, 0.29f, 0.29f, 0.77f, 0.0f, 1.06f)
                lineToRelative(-0.88f, 0.88f)
                lineToRelative(0.88f, 0.88f)
                curveToRelative(0.29f, 0.29f, 0.29f, 0.77f, 0.0f, 1.06f)
                verticalLineToRelative(0.0f)
                curveToRelative(-0.29f, 0.29f, -0.77f, 0.29f, -1.06f, 0.0f)
                lineTo(15.5f, 9.54f)
                lineToRelative(-0.88f, 0.88f)
                curveToRelative(-0.29f, 0.29f, -0.77f, 0.29f, -1.06f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.29f, -0.29f, -0.29f, -0.77f, 0.0f, -1.06f)
                lineToRelative(0.88f, -0.88f)
                lineToRelative(-0.88f, -0.88f)
                curveTo(13.26f, 7.3f, 13.26f, 6.82f, 13.56f, 6.53f)
                close()
                moveTo(7.0f, 7.72f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                verticalLineToRelative(0.0f)
                curveTo(6.25f, 8.06f, 6.59f, 7.72f, 7.0f, 7.72f)
                close()
                moveTo(10.75f, 16.0f)
                horizontalLineTo(9.5f)
                verticalLineToRelative(1.25f)
                curveTo(9.5f, 17.66f, 9.16f, 18.0f, 8.75f, 18.0f)
                horizontalLineToRelative(0.0f)
                curveTo(8.34f, 18.0f, 8.0f, 17.66f, 8.0f, 17.25f)
                verticalLineTo(16.0f)
                horizontalLineTo(6.75f)
                curveTo(6.34f, 16.0f, 6.0f, 15.66f, 6.0f, 15.25f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-1.25f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(1.25f)
                horizontalLineToRelative(1.25f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(0.0f)
                curveTo(11.5f, 15.66f, 11.16f, 16.0f, 10.75f, 16.0f)
                close()
                moveTo(17.25f, 17.25f)
                horizontalLineToRelative(-3.5f)
                curveToRelative(-0.41f, 0.0f, -0.75f, -0.34f, -0.75f, -0.75f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveTo(18.0f, 16.91f, 17.66f, 17.25f, 17.25f, 17.25f)
                close()
                moveTo(17.25f, 14.75f)
                horizontalLineToRelative(-3.5f)
                curveTo(13.34f, 14.75f, 13.0f, 14.41f, 13.0f, 14.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(0.0f)
                curveTo(18.0f, 14.41f, 17.66f, 14.75f, 17.25f, 14.75f)
                close()
            }
        }
        return _calculate!!
    }

private var _calculate: ImageVector? = null
