/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BikeScooter: ImageVector
    get() {
        if (_bikeScooter != null) {
            return _bikeScooter!!
        }
        _bikeScooter = materialIcon(name = "Rounded.BikeScooter") {
            materialPath {
                moveTo(10.0f, 14.0f)
                horizontalLineToRelative(0.74f)
                lineTo(8.82f, 5.56f)
                curveTo(8.61f, 4.65f, 7.8f, 4.0f, 6.87f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 4.0f, 3.0f, 4.45f, 3.0f, 5.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.87f)
                lineToRelative(1.42f, 6.25f)
                curveToRelative(0.0f, 0.0f, -0.01f, 0.0f, -0.01f, 0.0f)
                curveTo(6.12f, 12.9f, 4.47f, 14.73f, 4.09f, 17.0f)
                horizontalLineTo(0.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-1.0f)
                curveTo(6.0f, 15.79f, 7.79f, 14.0f, 10.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(18.75f, 8.0f)
                lineToRelative(-0.56f, 0.0f)
                lineToRelative(-1.35f, -3.69f)
                curveTo(16.55f, 3.52f, 15.8f, 3.0f, 14.96f, 3.0f)
                horizontalLineTo(12.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.96f)
                lineToRelative(1.1f, 3.0f)
                horizontalLineTo(10.4f)
                lineToRelative(0.46f, 2.0f)
                horizontalLineTo(15.0f)
                curveToRelative(-0.43f, 0.58f, -0.75f, 1.25f, -0.9f, 2.0f)
                horizontalLineToRelative(-2.79f)
                lineToRelative(0.46f, 2.0f)
                horizontalLineToRelative(2.33f)
                curveToRelative(0.44f, 2.23f, 2.31f, 3.88f, 4.65f, 3.99f)
                curveToRelative(3.16f, 0.15f, 5.88f, -2.83f, 5.12f, -6.1f)
                curveTo(23.34f, 9.57f, 21.13f, 8.0f, 18.75f, 8.0f)
                close()
                moveTo(18.88f, 16.0f)
                curveToRelative(-1.54f, -0.06f, -2.84f, -1.37f, -2.88f, -2.92f)
                curveToRelative(-0.02f, -0.96f, 0.39f, -1.8f, 1.05f, -2.36f)
                lineToRelative(0.62f, 1.7f)
                curveToRelative(0.19f, 0.52f, 0.76f, 0.79f, 1.28f, 0.6f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.52f, -0.19f, 0.79f, -0.76f, 0.6f, -1.28f)
                lineToRelative(-0.63f, -1.73f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.01f, -0.01f)
                curveTo(20.64f, 9.96f, 22.0f, 11.29f, 22.0f, 13.0f)
                curveTo(22.0f, 14.72f, 20.62f, 16.06f, 18.88f, 16.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 15.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(11.66f, 15.0f, 10.0f, 15.0f)
                close()
                moveTo(10.0f, 19.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(10.55f, 19.0f, 10.0f, 19.0f)
                close()
            }
        }
        return _bikeScooter!!
    }

private var _bikeScooter: ImageVector? = null
