/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.PathFillType.Companion.EvenOdd
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.BuildCircle: ImageVector
    get() {
        if (_buildCircle != null) {
            return _buildCircle!!
        }
        _buildCircle = materialIcon(name = "Outlined.BuildCircle") {
            materialPath(pathFillType = EvenOdd) {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -4.41f, 3.59f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.59f, 8.0f, 8.0f)
                curveTo(20.0f, 16.41f, 16.41f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath(pathFillType = EvenOdd) {
                moveTo(13.49f, 11.38f)
                curveToRelative(0.43f, -1.22f, 0.17f, -2.64f, -0.81f, -3.62f)
                curveToRelative(-1.11f, -1.11f, -2.79f, -1.3f, -4.1f, -0.59f)
                lineToRelative(2.35f, 2.35f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(7.17f, 8.58f)
                curveToRelative(-0.71f, 1.32f, -0.52f, 2.99f, 0.59f, 4.1f)
                curveToRelative(0.98f, 0.98f, 2.4f, 1.24f, 3.62f, 0.81f)
                lineToRelative(3.41f, 3.41f)
                curveToRelative(0.2f, 0.2f, 0.51f, 0.2f, 0.71f, 0.0f)
                lineToRelative(1.4f, -1.4f)
                curveToRelative(0.2f, -0.2f, 0.2f, -0.51f, 0.0f, -0.71f)
                lineTo(13.49f, 11.38f)
                close()
            }
        }
        return _buildCircle!!
    }

private var _buildCircle: ImageVector? = null
