/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PermScanWifi: ImageVector
    get() {
        if (_permScanWifi != null) {
            return _permScanWifi!!
        }
        _permScanWifi = materialIcon(name = "Filled.PermScanWifi") {
            materialPath {
                moveTo(12.0f, 3.0f)
                curveTo(6.95f, 3.0f, 3.15f, 4.85f, 0.0f, 7.23f)
                lineTo(12.0f, 22.0f)
                lineTo(24.0f, 7.25f)
                curveTo(20.85f, 4.87f, 17.05f, 3.0f, 12.0f, 3.0f)
                close()
                moveTo(13.0f, 16.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(11.0f, 8.0f)
                lineTo(11.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
        }
        return _permScanWifi!!
    }

private var _permScanWifi: ImageVector? = null
