/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DoNotDisturbOff: ImageVector
    get() {
        if (_doNotDisturbOff != null) {
            return _doNotDisturbOff!!
        }
        _doNotDisturbOff = materialIcon(name = "Filled.DoNotDisturbOff") {
            materialPath {
                moveTo(17.0f, 11.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-1.46f)
                lineToRelative(4.68f, 4.68f)
                curveTo(21.34f, 16.07f, 22.0f, 14.11f, 22.0f, 12.0f)
                curveToRelative(0.0f, -5.52f, -4.48f, -10.0f, -10.0f, -10.0f)
                curveToRelative(-2.11f, 0.0f, -4.07f, 0.66f, -5.68f, 1.78f)
                lineTo(13.54f, 11.0f)
                horizontalLineTo(17.0f)
                close()
                moveTo(2.27f, 2.27f)
                lineTo(1.0f, 3.54f)
                lineToRelative(2.78f, 2.78f)
                curveTo(2.66f, 7.93f, 2.0f, 9.89f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(2.11f, 0.0f, 4.07f, -0.66f, 5.68f, -1.78f)
                lineTo(20.46f, 23.0f)
                lineToRelative(1.27f, -1.27f)
                lineTo(11.0f, 11.0f)
                lineTo(2.27f, 2.27f)
                close()
                moveTo(7.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.46f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(7.0f)
                close()
            }
        }
        return _doNotDisturbOff!!
    }

private var _doNotDisturbOff: ImageVector? = null
