/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Diversity1: ImageVector
    get() {
        if (_diversity1 != null) {
            return _diversity1!!
        }
        _diversity1 = materialIcon(name = "Filled.Diversity1") {
            materialPath {
                moveTo(4.0f, 14.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(1.22f, 17.58f)
                curveTo(0.48f, 17.9f, 0.0f, 18.62f, 0.0f, 19.43f)
                verticalLineTo(21.0f)
                lineToRelative(4.5f, 0.0f)
                verticalLineToRelative(-1.61f)
                curveToRelative(0.0f, -0.83f, 0.23f, -1.61f, 0.63f, -2.29f)
                curveTo(4.76f, 17.04f, 4.39f, 17.0f, 4.0f, 17.0f)
                curveTo(3.01f, 17.0f, 2.07f, 17.21f, 1.22f, 17.58f)
                close()
            }
            materialPath {
                moveTo(20.0f, 14.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(22.78f, 17.58f)
                curveTo(21.93f, 17.21f, 20.99f, 17.0f, 20.0f, 17.0f)
                curveToRelative(-0.39f, 0.0f, -0.76f, 0.04f, -1.13f, 0.1f)
                curveToRelative(0.4f, 0.68f, 0.63f, 1.46f, 0.63f, 2.29f)
                verticalLineTo(21.0f)
                lineToRelative(4.5f, 0.0f)
                verticalLineToRelative(-1.57f)
                curveTo(24.0f, 18.62f, 23.52f, 17.9f, 22.78f, 17.58f)
                close()
            }
            materialPath {
                moveTo(16.24f, 16.65f)
                curveToRelative(-1.17f, -0.52f, -2.61f, -0.9f, -4.24f, -0.9f)
                curveToRelative(-1.63f, 0.0f, -3.07f, 0.39f, -4.24f, 0.9f)
                curveTo(6.68f, 17.13f, 6.0f, 18.21f, 6.0f, 19.39f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.61f)
                curveTo(18.0f, 18.21f, 17.32f, 17.13f, 16.24f, 16.65f)
                close()
            }
            materialPath {
                moveTo(9.0f, 12.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 10.34f, 9.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(2.48f, 10.86f)
                curveTo(2.17f, 10.1f, 2.0f, 9.36f, 2.0f, 8.6f)
                curveTo(2.0f, 6.02f, 4.02f, 4.0f, 6.6f, 4.0f)
                curveToRelative(2.68f, 0.0f, 3.82f, 1.74f, 5.4f, 3.59f)
                curveTo(13.57f, 5.76f, 14.7f, 4.0f, 17.4f, 4.0f)
                curveTo(19.98f, 4.0f, 22.0f, 6.02f, 22.0f, 8.6f)
                curveToRelative(0.0f, 0.76f, -0.17f, 1.5f, -0.48f, 2.26f)
                curveToRelative(0.65f, 0.31f, 1.18f, 0.82f, 1.53f, 1.44f)
                curveTo(23.65f, 11.1f, 24.0f, 9.88f, 24.0f, 8.6f)
                curveTo(24.0f, 4.9f, 21.1f, 2.0f, 17.4f, 2.0f)
                curveToRelative(-2.09f, 0.0f, -4.09f, 0.97f, -5.4f, 2.51f)
                curveTo(10.69f, 2.97f, 8.69f, 2.0f, 6.6f, 2.0f)
                curveTo(2.9f, 2.0f, 0.0f, 4.9f, 0.0f, 8.6f)
                curveToRelative(0.0f, 1.28f, 0.35f, 2.5f, 0.96f, 3.7f)
                curveTo(1.31f, 11.68f, 1.84f, 11.17f, 2.48f, 10.86f)
                close()
            }
        }
        return _diversity1!!
    }

private var _diversity1: ImageVector? = null
