/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Chalet: ImageVector
    get() {
        if (_chalet != null) {
            return _chalet!!
        }
        _chalet = materialIcon(name = "Filled.Chalet") {
            materialPath {
                moveTo(10.0f, 7.5f)
                lineToRelative(7.5f, 7.5f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(15.0f, 15.33f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-4.67f)
                lineToRelative(-1.09f, 1.09f)
                lineTo(2.5f, 15.0f)
                lineTo(10.0f, 7.5f)
                close()
                moveTo(22.0f, 6.5f)
                horizontalLineToRelative(-1.19f)
                lineToRelative(0.75f, -0.75f)
                lineToRelative(-0.71f, -0.71f)
                lineTo(19.39f, 6.5f)
                horizontalLineTo(18.5f)
                verticalLineTo(5.61f)
                lineToRelative(1.45f, -1.45f)
                lineToRelative(-0.71f, -0.71f)
                lineTo(18.5f, 4.19f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.19f)
                lineToRelative(-0.75f, -0.75f)
                lineToRelative(-0.71f, 0.71f)
                lineToRelative(1.45f, 1.45f)
                verticalLineTo(6.5f)
                horizontalLineToRelative(-0.89f)
                lineToRelative(-1.45f, -1.45f)
                lineToRelative(-0.71f, 0.71f)
                lineToRelative(0.75f, 0.75f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.19f)
                lineToRelative(-0.75f, 0.75f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(1.45f, -1.45f)
                horizontalLineToRelative(0.89f)
                verticalLineToRelative(0.89f)
                lineToRelative(-1.45f, 1.45f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(0.75f, -0.75f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(9.81f)
                lineToRelative(0.75f, 0.75f)
                lineToRelative(0.71f, -0.71f)
                lineTo(18.5f, 8.39f)
                verticalLineTo(7.5f)
                horizontalLineToRelative(0.89f)
                lineToRelative(1.45f, 1.45f)
                lineToRelative(0.71f, -0.71f)
                lineTo(20.81f, 7.5f)
                horizontalLineTo(22.0f)
                verticalLineTo(6.5f)
                close()
            }
        }
        return _chalet!!
    }

private var _chalet: ImageVector? = null
