/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NearbyError: ImageVector
    get() {
        if (_nearbyError != null) {
            return _nearbyError!!
        }
        _nearbyError = materialIcon(name = "Sharp.NearbyError") {
            materialPath {
                moveTo(12.0f, 7.58f)
                lineTo(16.42f, 12.0f)
                lineTo(12.0f, 16.42f)
                lineTo(7.58f, 12.0f)
                lineTo(12.0f, 7.58f)
                close()
                moveTo(12.0f, 19.2f)
                lineTo(4.8f, 12.0f)
                lineTo(12.0f, 4.8f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(7.17f)
                lineToRelative(-5.99f, -5.99f)
                lineTo(1.18f, 12.01f)
                lineToRelative(10.83f, 10.83f)
                lineTo(18.0f, 16.83f)
                verticalLineTo(13.2f)
                lineTo(12.0f, 19.2f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(22.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.0f)
            }
        }
        return _nearbyError!!
    }

private var _nearbyError: ImageVector? = null
