/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ModeOfTravel: ImageVector
    get() {
        if (_modeOfTravel != null) {
            return _modeOfTravel!!
        }
        _modeOfTravel = materialIcon(name = "TwoTone.ModeOfTravel") {
            materialPath {
                moveTo(15.31f, 18.9f)
                curveToRelative(-0.96f, 1.0f, -2.06f, 2.03f, -3.31f, 3.1f)
                curveToRelative(-5.33f, -4.55f, -8.0f, -8.48f, -8.0f, -11.8f)
                curveTo(4.0f, 5.22f, 7.8f, 2.0f, 12.0f, 2.0f)
                curveToRelative(4.0f, 0.0f, 7.64f, 2.92f, 7.97f, 7.5f)
                lineToRelative(3.53f, 0.0f)
                lineTo(19.0f, 14.0f)
                lineToRelative(-4.5f, -4.5f)
                lineToRelative(3.47f, 0.0f)
                curveTo(17.65f, 6.24f, 15.13f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-3.35f, 0.0f, -6.0f, 2.57f, -6.0f, 6.2f)
                curveToRelative(0.0f, 2.34f, 1.95f, 5.44f, 6.0f, 9.14f)
                curveToRelative(0.64f, -0.59f, 1.23f, -1.16f, 1.77f, -1.71f)
                curveToRelative(-0.17f, -0.34f, -0.27f, -0.72f, -0.27f, -1.12f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.12f, 2.5f, 2.5f)
                reflectiveCurveTo(17.38f, 19.0f, 16.0f, 19.0f)
                curveTo(15.76f, 19.0f, 15.53f, 18.97f, 15.31f, 18.9f)
                close()
            }
        }
        return _modeOfTravel!!
    }

private var _modeOfTravel: ImageVector? = null
