/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.EditRoad: ImageVector
    get() {
        if (_editRoad != null) {
            return _editRoad!!
        }
        _editRoad = materialIcon(name = "Sharp.EditRoad") {
            materialPath {
                moveTo(18.0f, 4.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 7.9f)
                lineToRelative(2.0f, -2.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 10.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(10.0f, 16.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(22.56f, 12.59f)
                lineToRelative(-1.15f, -1.15f)
                curveToRelative(-0.59f, -0.59f, -1.54f, -0.59f, -2.12f, 0.0f)
                lineTo(14.0f, 16.73f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(3.27f)
                lineToRelative(5.29f, -5.29f)
                curveTo(23.15f, 14.12f, 23.15f, 13.17f, 22.56f, 12.59f)
                close()
                moveTo(16.58f, 18.45f)
                horizontalLineToRelative(-1.03f)
                verticalLineToRelative(-1.03f)
                lineTo(19.0f, 13.97f)
                lineTo(20.03f, 15.0f)
                lineTo(16.58f, 18.45f)
                close()
            }
        }
        return _editRoad!!
    }

private var _editRoad: ImageVector? = null
