/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Balcony: ImageVector
    get() {
        if (_balcony != null) {
            return _balcony!!
        }
        _balcony = materialIcon(name = "Rounded.Balcony") {
            materialPath {
                moveTo(20.0f, 14.27f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -4.42f, -3.58f, -8.0f, -8.0f, -8.0f)
                reflectiveCurveToRelative(-8.0f, 3.58f, -8.0f, 8.0f)
                verticalLineToRelative(4.27f)
                curveTo(3.4f, 14.61f, 3.0f, 15.26f, 3.0f, 16.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                curveTo(21.0f, 15.26f, 20.6f, 14.61f, 20.0f, 14.27f)
                close()
                moveTo(7.0f, 20.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(11.0f, 20.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(11.0f, 14.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -2.97f, 2.16f, -5.44f, 5.0f, -5.92f)
                verticalLineTo(14.0f)
                close()
                moveTo(13.0f, 4.08f)
                curveToRelative(2.84f, 0.48f, 5.0f, 2.94f, 5.0f, 5.92f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(4.08f)
                close()
                moveTo(15.0f, 20.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(19.0f, 20.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(8.0f, 11.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveTo(8.0f, 11.55f, 8.0f, 11.0f)
                close()
                moveTo(16.0f, 11.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveTo(16.0f, 10.45f, 16.0f, 11.0f)
                close()
            }
        }
        return _balcony!!
    }

private var _balcony: ImageVector? = null
