/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ArrowBackIosNew: ImageVector
    get() {
        if (_arrowBackIosNew != null) {
            return _arrowBackIosNew!!
        }
        _arrowBackIosNew = materialIcon(name = "Rounded.ArrowBackIosNew") {
            materialPath {
                moveTo(16.88f, 2.88f)
                lineTo(16.88f, 2.88f)
                curveToRelative(-0.49f, -0.49f, -1.28f, -0.49f, -1.77f, 0.0f)
                lineToRelative(-8.41f, 8.41f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(8.41f, 8.41f)
                curveToRelative(0.49f, 0.49f, 1.28f, 0.49f, 1.77f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.49f, -0.49f, 0.49f, -1.28f, 0.0f, -1.77f)
                lineTo(9.54f, 12.0f)
                lineToRelative(7.35f, -7.35f)
                curveTo(17.37f, 4.16f, 17.37f, 3.37f, 16.88f, 2.88f)
                close()
            }
        }
        return _arrowBackIosNew!!
    }

private var _arrowBackIosNew: ImageVector? = null
