/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Snowboarding: ImageVector
    get() {
        if (_snowboarding != null) {
            return _snowboarding!!
        }
        _snowboarding = materialIcon(name = "TwoTone.Snowboarding") {
            materialPath {
                moveTo(14.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveTo(14.0f, 4.1f, 14.0f, 3.0f)
                close()
                moveTo(21.4f, 20.09f)
                curveToRelative(-0.23f, -0.05f, -0.46f, 0.02f, -0.64f, 0.17f)
                curveToRelative(-0.69f, 0.6f, -1.64f, 0.88f, -2.6f, 0.67f)
                lineTo(17.0f, 20.69f)
                lineToRelative(-1.0f, -6.19f)
                lineToRelative(-3.32f, -2.67f)
                lineToRelative(1.8f, -2.89f)
                curveTo(15.63f, 10.78f, 17.68f, 12.0f, 20.0f, 12.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-1.85f, 0.0f, -3.44f, -1.12f, -4.13f, -2.72f)
                lineToRelative(-0.52f, -1.21f)
                curveTo(15.16f, 5.64f, 14.61f, 5.0f, 13.7f, 5.0f)
                horizontalLineTo(8.0f)
                lineTo(5.5f, 9.0f)
                lineToRelative(1.7f, 1.06f)
                lineTo(9.1f, 7.0f)
                horizontalLineToRelative(2.35f)
                lineToRelative(-2.51f, 3.99f)
                curveToRelative(-0.28f, 0.45f, -0.37f, 1.0f, -0.25f, 1.52f)
                lineTo(9.5f, 16.0f)
                lineTo(6.0f, 18.35f)
                lineToRelative(-0.47f, -0.1f)
                curveToRelative(-0.96f, -0.2f, -1.71f, -0.85f, -2.1f, -1.67f)
                curveToRelative(-0.1f, -0.21f, -0.28f, -0.37f, -0.51f, -0.42f)
                curveToRelative(-0.43f, -0.09f, -0.82f, 0.2f, -0.9f, 0.58f)
                curveTo(1.98f, 16.88f, 2.0f, 17.05f, 2.07f, 17.2f)
                curveToRelative(0.58f, 1.24f, 1.71f, 2.2f, 3.15f, 2.51f)
                lineToRelative(12.63f, 2.69f)
                curveToRelative(1.44f, 0.31f, 2.86f, -0.11f, 3.9f, -1.01f)
                curveToRelative(0.13f, -0.11f, 0.21f, -0.26f, 0.24f, -0.41f)
                curveTo(22.06f, 20.6f, 21.83f, 20.18f, 21.4f, 20.09f)
                close()
                moveTo(8.73f, 18.93f)
                lineToRelative(3.02f, -2.03f)
                lineToRelative(-0.44f, -3.32f)
                lineToRelative(2.84f, 2.02f)
                lineToRelative(0.75f, 4.64f)
                lineTo(8.73f, 18.93f)
                close()
            }
        }
        return _snowboarding!!
    }

private var _snowboarding: ImageVector? = null
