/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.TableBar: ImageVector
    get() {
        if (_tableBar != null) {
            return _tableBar!!
        }
        _tableBar = materialIcon(name = "Rounded.TableBar") {
            materialPath {
                moveTo(22.0f, 7.5f)
                curveTo(22.0f, 5.57f, 17.52f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(2.0f, 5.57f, 2.0f, 7.5f)
                curveToRelative(0.0f, 1.81f, 3.95f, 3.31f, 9.0f, 3.48f)
                verticalLineTo(15.0f)
                horizontalLineTo(9.35f)
                curveToRelative(-0.82f, 0.0f, -1.55f, 0.5f, -1.86f, 1.26f)
                lineToRelative(-0.99f, 2.47f)
                curveTo(6.27f, 19.34f, 6.71f, 20.0f, 7.37f, 20.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.38f, 0.0f, 0.72f, -0.23f, 0.86f, -0.58f)
                lineTo(9.2f, 17.0f)
                horizontalLineToRelative(5.6f)
                lineToRelative(0.97f, 2.42f)
                curveToRelative(0.14f, 0.35f, 0.48f, 0.58f, 0.86f, 0.58f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.66f, 0.0f, 1.11f, -0.66f, 0.86f, -1.27f)
                lineToRelative(-0.99f, -2.47f)
                curveTo(16.2f, 15.5f, 15.46f, 15.0f, 14.65f, 15.0f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(-4.02f)
                curveTo(18.05f, 10.81f, 22.0f, 9.31f, 22.0f, 7.5f)
                close()
            }
        }
        return _tableBar!!
    }

private var _tableBar: ImageVector? = null
