/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SatelliteAlt: ImageVector
    get() {
        if (_satelliteAlt != null) {
            return _satelliteAlt!!
        }
        _satelliteAlt = materialIcon(name = "Rounded.SatelliteAlt") {
            materialPath {
                moveTo(20.95f, 14.88f)
                curveToRelative(-0.4f, 3.18f, -2.89f, 5.67f, -6.07f, 6.07f)
                curveTo(14.37f, 21.01f, 14.0f, 21.44f, 14.0f, 21.94f)
                curveToRelative(0.0f, 0.04f, 0.0f, 0.08f, 0.01f, 0.12f)
                curveToRelative(0.07f, 0.55f, 0.57f, 0.94f, 1.12f, 0.87f)
                curveToRelative(4.09f, -0.51f, 7.3f, -3.72f, 7.81f, -7.81f)
                curveToRelative(0.06f, -0.55f, -0.33f, -1.05f, -0.88f, -1.11f)
                curveTo(21.51f, 13.94f, 21.01f, 14.33f, 20.95f, 14.88f)
                close()
                moveTo(18.84f, 15.26f)
                curveToRelative(0.14f, -0.53f, -0.18f, -1.08f, -0.72f, -1.22f)
                curveToRelative(-0.54f, -0.14f, -1.08f, 0.18f, -1.22f, 0.72f)
                curveToRelative(-0.27f, 1.05f, -1.09f, 1.87f, -2.15f, 2.15f)
                curveTo(14.3f, 17.03f, 14.0f, 17.43f, 14.0f, 17.88f)
                curveToRelative(0.0f, 0.08f, 0.01f, 0.17f, 0.03f, 0.25f)
                curveToRelative(0.14f, 0.53f, 0.69f, 0.85f, 1.22f, 0.72f)
                curveTo(17.02f, 18.38f, 18.39f, 17.01f, 18.84f, 15.26f)
                close()
                moveTo(21.8f, 4.12f)
                lineToRelative(-3.54f, -3.54f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineToRelative(-3.18f, 3.18f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(1.24f, 1.24f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(11.55f, 7.3f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineTo(7.3f, 8.72f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(1.24f, 1.24f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(6.6f, 12.25f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineToRelative(-3.18f, 3.18f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(3.54f, 3.54f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(3.18f, -3.18f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-1.24f, -1.24f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(1.24f, 1.24f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(1.41f, -1.41f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineTo(13.84f, 9.6f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(1.24f, 1.24f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(3.18f, -3.18f)
                curveTo(22.58f, 6.17f, 22.58f, 4.9f, 21.8f, 4.12f)
                close()
                moveTo(5.54f, 20.38f)
                lineTo(2.0f, 16.85f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(3.54f, 3.54f)
                lineTo(5.54f, 20.38f)
                close()
                moveTo(7.66f, 18.26f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(3.54f, 3.54f)
                lineTo(7.66f, 18.26f)
                close()
                moveTo(17.2f, 8.72f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(3.54f, 3.54f)
                lineTo(17.2f, 8.72f)
                close()
                moveTo(19.32f, 6.6f)
                lineToRelative(-3.54f, -3.54f)
                lineTo(16.85f, 2.0f)
                lineToRelative(3.54f, 3.54f)
                lineTo(19.32f, 6.6f)
                close()
            }
        }
        return _satelliteAlt!!
    }

private var _satelliteAlt: ImageVector? = null
