/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FaceRetouchingNatural: ImageVector
    get() {
        if (_faceRetouchingNatural != null) {
            return _faceRetouchingNatural!!
        }
        _faceRetouchingNatural = materialIcon(name = "Outlined.FaceRetouchingNatural") {
            materialPath {
                moveTo(19.89f, 10.75f)
                curveTo(19.96f, 11.16f, 20.0f, 11.57f, 20.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, -3.59f, 8.0f, -8.0f, 8.0f)
                reflectiveCurveToRelative(-8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -0.05f, 0.01f, -0.1f, 0.0f, -0.14f)
                curveToRelative(2.6f, -0.98f, 4.69f, -2.99f, 5.74f, -5.55f)
                curveToRelative(3.38f, 4.14f, 7.97f, 3.73f, 8.99f, 3.61f)
                lineToRelative(-0.89f, -1.93f)
                curveToRelative(-0.13f, 0.01f, -4.62f, 0.38f, -7.18f, -3.86f)
                curveToRelative(1.01f, -0.16f, 1.71f, -0.15f, 2.59f, -0.01f)
                curveToRelative(2.52f, -1.15f, 1.93f, -0.89f, 2.76f, -1.26f)
                curveTo(14.78f, 2.3f, 13.43f, 2.0f, 12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveToRelative(0.0f, -1.43f, -0.3f, -2.78f, -0.84f, -4.01f)
                lineTo(19.89f, 10.75f)
                close()
                moveTo(8.08f, 5.03f)
                curveTo(7.45f, 6.92f, 6.13f, 8.5f, 4.42f, 9.47f)
                curveTo(5.05f, 7.58f, 6.37f, 6.0f, 8.08f, 5.03f)
                close()
            }
            materialPath {
                moveTo(15.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(9.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(23.0f, 4.5f)
                lineToRelative(-2.4f, -1.1f)
                lineToRelative(-1.1f, -2.4f)
                lineToRelative(-1.1f, 2.4f)
                lineToRelative(-2.4f, 1.1f)
                lineToRelative(2.4f, 1.1f)
                lineToRelative(1.1f, 2.4f)
                lineToRelative(1.1f, -2.4f)
                close()
            }
        }
        return _faceRetouchingNatural!!
    }

private var _faceRetouchingNatural: ImageVector? = null
