/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Agriculture: ImageVector
    get() {
        if (_agriculture != null) {
            return _agriculture!!
        }
        _agriculture = materialIcon(name = "Filled.Agriculture") {
            materialPath {
                moveTo(19.5f, 12.0f)
                curveToRelative(0.93f, 0.0f, 1.78f, 0.28f, 2.5f, 0.76f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-6.29f)
                lineToRelative(-1.06f, -1.06f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-0.71f, -0.71f)
                lineTo(9.82f, 6.35f)
                lineToRelative(0.71f, 0.71f)
                lineToRelative(1.41f, -1.41f)
                lineTo(13.0f, 6.71f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineToRelative(-0.54f)
                curveToRelative(0.95f, 1.06f, 1.54f, 2.46f, 1.54f, 4.0f)
                curveToRelative(0.0f, 0.34f, -0.04f, 0.67f, -0.09f, 1.0f)
                horizontalLineToRelative(3.14f)
                curveTo(15.3f, 13.75f, 17.19f, 12.0f, 19.5f, 12.0f)
                close()
            }
            materialPath {
                moveTo(19.5f, 13.0f)
                curveToRelative(-1.93f, 0.0f, -3.5f, 1.57f, -3.5f, 3.5f)
                reflectiveCurveToRelative(1.57f, 3.5f, 3.5f, 3.5f)
                reflectiveCurveToRelative(3.5f, -1.57f, 3.5f, -3.5f)
                reflectiveCurveTo(21.43f, 13.0f, 19.5f, 13.0f)
                close()
                moveTo(19.5f, 18.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(20.33f, 18.0f, 19.5f, 18.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 9.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 7.0f, 3.0f, 7.45f, 3.0f, 8.0f)
                curveTo(3.0f, 8.55f, 3.45f, 9.0f, 4.0f, 9.0f)
                close()
            }
            materialPath {
                moveTo(9.83f, 13.82f)
                lineToRelative(-0.18f, -0.47f)
                lineTo(10.58f, 13.0f)
                curveToRelative(-0.46f, -1.06f, -1.28f, -1.91f, -2.31f, -2.43f)
                lineToRelative(-0.4f, 0.89f)
                lineToRelative(-0.46f, -0.21f)
                lineToRelative(0.4f, -0.9f)
                curveTo(7.26f, 10.13f, 6.64f, 10.0f, 6.0f, 10.0f)
                curveToRelative(-0.53f, 0.0f, -1.04f, 0.11f, -1.52f, 0.26f)
                lineToRelative(0.34f, 0.91f)
                lineToRelative(-0.47f, 0.18f)
                lineTo(4.0f, 10.42f)
                curveToRelative(-1.06f, 0.46f, -1.91f, 1.28f, -2.43f, 2.31f)
                lineToRelative(0.89f, 0.4f)
                lineToRelative(-0.21f, 0.46f)
                lineToRelative(-0.9f, -0.4f)
                curveTo(1.13f, 13.74f, 1.0f, 14.36f, 1.0f, 15.0f)
                curveToRelative(0.0f, 0.53f, 0.11f, 1.04f, 0.26f, 1.52f)
                lineToRelative(0.91f, -0.34f)
                lineToRelative(0.18f, 0.47f)
                lineTo(1.42f, 17.0f)
                curveToRelative(0.46f, 1.06f, 1.28f, 1.91f, 2.31f, 2.43f)
                lineToRelative(0.4f, -0.89f)
                lineToRelative(0.46f, 0.21f)
                lineToRelative(-0.4f, 0.9f)
                curveTo(4.74f, 19.87f, 5.36f, 20.0f, 6.0f, 20.0f)
                curveToRelative(0.53f, 0.0f, 1.04f, -0.11f, 1.52f, -0.26f)
                lineToRelative(-0.34f, -0.91f)
                lineToRelative(0.47f, -0.18f)
                lineTo(8.0f, 19.58f)
                curveToRelative(1.06f, -0.46f, 1.91f, -1.28f, 2.43f, -2.31f)
                lineToRelative(-0.89f, -0.4f)
                lineToRelative(0.21f, -0.46f)
                lineToRelative(0.9f, 0.4f)
                curveTo(10.87f, 16.26f, 11.0f, 15.64f, 11.0f, 15.0f)
                curveToRelative(0.0f, -0.53f, -0.11f, -1.04f, -0.26f, -1.52f)
                lineTo(9.83f, 13.82f)
                close()
                moveTo(7.15f, 17.77f)
                curveToRelative(-1.53f, 0.63f, -3.29f, -0.09f, -3.92f, -1.62f)
                curveToRelative(-0.63f, -1.53f, 0.09f, -3.29f, 1.62f, -3.92f)
                curveToRelative(1.53f, -0.63f, 3.29f, 0.09f, 3.92f, 1.62f)
                curveTo(9.41f, 15.38f, 8.68f, 17.14f, 7.15f, 17.77f)
                close()
            }
        }
        return _agriculture!!
    }

private var _agriculture: ImageVector? = null
