/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FilterVintage: ImageVector
    get() {
        if (_filterVintage != null) {
            return _filterVintage!!
        }
        _filterVintage = materialIcon(name = "TwoTone.FilterVintage") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.69f, 7.61f)
                curveToRelative(-0.7f, 0.0f, -1.39f, 0.19f, -2.0f, 0.54f)
                curveToRelative(-0.16f, 0.09f, -0.32f, 0.21f, -0.54f, 0.37f)
                lineToRelative(-1.13f, 0.9f)
                curveToRelative(0.31f, 0.36f, 0.56f, 0.78f, 0.72f, 1.24f)
                lineToRelative(1.38f, -0.52f)
                curveToRelative(0.22f, -0.08f, 0.41f, -0.17f, 0.58f, -0.27f)
                curveToRelative(0.84f, -0.49f, 1.47f, -1.27f, 1.78f, -2.18f)
                curveToRelative(-0.26f, -0.06f, -0.52f, -0.08f, -0.79f, -0.08f)
                close()
                moveTo(17.13f, 13.87f)
                lineToRelative(-1.38f, -0.52f)
                curveToRelative(-0.16f, 0.45f, -0.4f, 0.85f, -0.7f, 1.21f)
                lineToRelative(1.15f, 0.96f)
                curveToRelative(0.15f, 0.12f, 0.31f, 0.24f, 0.49f, 0.34f)
                curveToRelative(0.61f, 0.35f, 1.3f, 0.54f, 1.99f, 0.54f)
                curveToRelative(0.27f, 0.0f, 0.53f, -0.03f, 0.8f, -0.08f)
                curveToRelative(-0.31f, -0.91f, -0.94f, -1.69f, -1.78f, -2.18f)
                curveToRelative(-0.16f, -0.1f, -0.35f, -0.19f, -0.57f, -0.27f)
                close()
                moveTo(11.0f, 6.0f)
                curveToRelative(0.0f, 0.19f, 0.02f, 0.41f, 0.05f, 0.63f)
                lineToRelative(0.23f, 1.44f)
                curveToRelative(0.24f, -0.04f, 0.48f, -0.07f, 0.72f, -0.07f)
                reflectiveCurveToRelative(0.48f, 0.03f, 0.71f, 0.07f)
                lineToRelative(0.23f, -1.44f)
                curveToRelative(0.04f, -0.22f, 0.06f, -0.44f, 0.06f, -0.63f)
                curveToRelative(0.0f, -0.98f, -0.37f, -1.91f, -1.0f, -2.63f)
                curveToRelative(-0.63f, 0.72f, -1.0f, 1.65f, -1.0f, 2.63f)
                close()
                moveTo(12.71f, 15.93f)
                curveToRelative(-0.23f, 0.04f, -0.47f, 0.07f, -0.71f, 0.07f)
                curveToRelative(-0.25f, 0.0f, -0.49f, -0.03f, -0.72f, -0.07f)
                lineToRelative(-0.22f, 1.42f)
                curveToRelative(-0.04f, 0.24f, -0.06f, 0.45f, -0.06f, 0.65f)
                curveToRelative(0.0f, 0.98f, 0.37f, 1.91f, 1.0f, 2.63f)
                curveToRelative(0.63f, -0.72f, 1.0f, -1.66f, 1.0f, -2.63f)
                curveToRelative(0.0f, -0.19f, -0.02f, -0.41f, -0.05f, -0.63f)
                lineToRelative(-0.24f, -1.44f)
                close()
                moveTo(6.87f, 10.12f)
                lineToRelative(1.38f, 0.52f)
                curveToRelative(0.16f, -0.44f, 0.4f, -0.85f, 0.7f, -1.2f)
                lineTo(7.8f, 8.49f)
                curveToRelative(-0.17f, -0.15f, -0.34f, -0.27f, -0.49f, -0.35f)
                curveToRelative(-0.62f, -0.36f, -1.3f, -0.54f, -2.0f, -0.54f)
                curveToRelative(-0.27f, 0.0f, -0.54f, 0.03f, -0.81f, 0.08f)
                curveToRelative(0.3f, 0.91f, 0.93f, 1.68f, 1.79f, 2.18f)
                curveToRelative(0.17f, 0.09f, 0.36f, 0.18f, 0.58f, 0.26f)
                close()
                moveTo(6.87f, 13.86f)
                curveToRelative(-0.22f, 0.08f, -0.41f, 0.17f, -0.58f, 0.27f)
                curveToRelative(-0.84f, 0.49f, -1.47f, 1.27f, -1.78f, 2.18f)
                curveToRelative(0.26f, 0.05f, 0.52f, 0.08f, 0.79f, 0.08f)
                curveToRelative(0.7f, 0.0f, 1.39f, -0.19f, 2.0f, -0.54f)
                curveToRelative(0.16f, -0.09f, 0.32f, -0.21f, 0.54f, -0.37f)
                lineToRelative(1.13f, -0.89f)
                curveToRelative(-0.31f, -0.36f, -0.56f, -0.78f, -0.72f, -1.24f)
                lineToRelative(-1.38f, 0.51f)
                close()
            }
            materialPath {
                moveTo(18.7f, 12.4f)
                curveToRelative(-0.28f, -0.16f, -0.57f, -0.29f, -0.86f, -0.4f)
                curveToRelative(0.29f, -0.11f, 0.58f, -0.24f, 0.86f, -0.4f)
                curveToRelative(1.92f, -1.11f, 2.99f, -3.12f, 3.0f, -5.19f)
                curveToRelative(-0.91f, -0.52f, -1.95f, -0.8f, -3.01f, -0.8f)
                curveToRelative(-1.02f, 0.0f, -2.05f, 0.26f, -2.99f, 0.8f)
                curveToRelative(-0.28f, 0.16f, -0.54f, 0.35f, -0.78f, 0.54f)
                curveToRelative(0.05f, -0.31f, 0.08f, -0.63f, 0.08f, -0.95f)
                curveToRelative(0.0f, -2.22f, -1.21f, -4.15f, -3.0f, -5.19f)
                curveTo(10.21f, 1.85f, 9.0f, 3.78f, 9.0f, 6.0f)
                curveToRelative(0.0f, 0.32f, 0.03f, 0.64f, 0.08f, 0.95f)
                curveToRelative(-0.24f, -0.2f, -0.5f, -0.39f, -0.78f, -0.55f)
                curveToRelative(-0.94f, -0.54f, -1.97f, -0.8f, -2.99f, -0.8f)
                curveToRelative(-1.05f, 0.0f, -2.1f, 0.28f, -3.01f, 0.8f)
                curveToRelative(0.0f, 2.07f, 1.07f, 4.08f, 3.0f, 5.19f)
                curveToRelative(0.28f, 0.16f, 0.57f, 0.29f, 0.86f, 0.4f)
                curveToRelative(-0.29f, 0.11f, -0.58f, 0.24f, -0.86f, 0.4f)
                curveToRelative(-1.92f, 1.11f, -2.99f, 3.12f, -3.0f, 5.19f)
                curveToRelative(0.91f, 0.52f, 1.95f, 0.8f, 3.01f, 0.8f)
                curveToRelative(1.02f, 0.0f, 2.05f, -0.26f, 2.99f, -0.8f)
                curveToRelative(0.28f, -0.16f, 0.54f, -0.35f, 0.78f, -0.54f)
                curveToRelative(-0.05f, 0.32f, -0.08f, 0.64f, -0.08f, 0.96f)
                curveToRelative(0.0f, 2.22f, 1.21f, 4.15f, 3.0f, 5.19f)
                curveToRelative(1.79f, -1.04f, 3.0f, -2.97f, 3.0f, -5.19f)
                curveToRelative(0.0f, -0.32f, -0.03f, -0.64f, -0.08f, -0.95f)
                curveToRelative(0.24f, 0.2f, 0.5f, 0.38f, 0.78f, 0.54f)
                curveToRelative(0.94f, 0.54f, 1.97f, 0.8f, 2.99f, 0.8f)
                curveToRelative(1.05f, 0.0f, 2.1f, -0.28f, 3.01f, -0.8f)
                curveToRelative(-0.01f, -2.07f, -1.08f, -4.08f, -3.0f, -5.19f)
                close()
                moveTo(4.51f, 7.68f)
                curveToRelative(0.26f, -0.06f, 0.53f, -0.08f, 0.8f, -0.08f)
                curveToRelative(0.69f, 0.0f, 1.38f, 0.18f, 1.99f, 0.54f)
                curveToRelative(0.15f, 0.09f, 0.32f, 0.2f, 0.49f, 0.35f)
                lineToRelative(1.15f, 0.96f)
                curveToRelative(-0.3f, 0.36f, -0.53f, 0.76f, -0.7f, 1.2f)
                lineToRelative(-1.38f, -0.52f)
                curveToRelative(-0.21f, -0.09f, -0.4f, -0.18f, -0.56f, -0.27f)
                curveToRelative(-0.87f, -0.5f, -1.49f, -1.27f, -1.79f, -2.18f)
                close()
                moveTo(7.84f, 15.47f)
                curveToRelative(-0.21f, 0.17f, -0.38f, 0.29f, -0.54f, 0.37f)
                curveToRelative(-0.61f, 0.35f, -1.3f, 0.54f, -2.0f, 0.54f)
                curveToRelative(-0.27f, 0.0f, -0.53f, -0.03f, -0.79f, -0.08f)
                curveToRelative(0.31f, -0.91f, 0.94f, -1.69f, 1.78f, -2.18f)
                curveToRelative(0.17f, -0.1f, 0.36f, -0.18f, 0.58f, -0.27f)
                lineToRelative(1.38f, -0.52f)
                curveToRelative(0.16f, 0.46f, 0.41f, 0.88f, 0.72f, 1.24f)
                lineToRelative(-1.13f, 0.9f)
                close()
                moveTo(12.0f, 3.37f)
                curveToRelative(0.63f, 0.72f, 1.0f, 1.66f, 1.0f, 2.63f)
                curveToRelative(0.0f, 0.19f, -0.02f, 0.41f, -0.05f, 0.63f)
                lineToRelative(-0.23f, 1.44f)
                curveTo(12.48f, 8.03f, 12.24f, 8.0f, 12.0f, 8.0f)
                reflectiveCurveToRelative(-0.48f, 0.03f, -0.71f, 0.07f)
                lineToRelative(-0.23f, -1.44f)
                curveTo(11.02f, 6.41f, 11.0f, 6.19f, 11.0f, 6.0f)
                curveToRelative(0.0f, -0.98f, 0.37f, -1.91f, 1.0f, -2.63f)
                close()
                moveTo(12.0f, 20.63f)
                curveToRelative(-0.63f, -0.72f, -1.0f, -1.66f, -1.0f, -2.63f)
                curveToRelative(0.0f, -0.2f, 0.02f, -0.41f, 0.06f, -0.65f)
                lineToRelative(0.22f, -1.42f)
                curveToRelative(0.23f, 0.04f, 0.47f, 0.07f, 0.72f, 0.07f)
                curveToRelative(0.24f, 0.0f, 0.48f, -0.03f, 0.71f, -0.07f)
                lineToRelative(0.23f, 1.44f)
                curveToRelative(0.04f, 0.22f, 0.06f, 0.44f, 0.06f, 0.63f)
                curveToRelative(0.0f, 0.98f, -0.37f, 1.91f, -1.0f, 2.63f)
                close()
                moveTo(12.0f, 14.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                close()
                moveTo(16.16f, 8.52f)
                curveToRelative(0.21f, -0.17f, 0.38f, -0.29f, 0.54f, -0.37f)
                curveToRelative(0.61f, -0.35f, 1.3f, -0.54f, 2.0f, -0.54f)
                curveToRelative(0.27f, 0.0f, 0.53f, 0.03f, 0.79f, 0.08f)
                curveToRelative(-0.31f, 0.91f, -0.94f, 1.69f, -1.78f, 2.18f)
                curveToRelative(-0.17f, 0.1f, -0.36f, 0.18f, -0.58f, 0.27f)
                lineToRelative(-1.38f, 0.52f)
                curveToRelative(-0.17f, -0.46f, -0.41f, -0.87f, -0.72f, -1.24f)
                lineToRelative(1.13f, -0.9f)
                close()
                moveTo(18.69f, 16.39f)
                curveToRelative(-0.69f, 0.0f, -1.38f, -0.18f, -1.99f, -0.54f)
                curveToRelative(-0.18f, -0.1f, -0.34f, -0.22f, -0.49f, -0.34f)
                lineToRelative(-1.15f, -0.96f)
                curveToRelative(0.3f, -0.36f, 0.54f, -0.76f, 0.7f, -1.21f)
                lineToRelative(1.38f, 0.52f)
                curveToRelative(0.22f, 0.08f, 0.41f, 0.17f, 0.57f, 0.26f)
                curveToRelative(0.85f, 0.49f, 1.47f, 1.27f, 1.78f, 2.18f)
                curveToRelative(-0.27f, 0.07f, -0.54f, 0.09f, -0.8f, 0.09f)
                close()
            }
        }
        return _filterVintage!!
    }

private var _filterVintage: ImageVector? = null
