/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.BedroomParent: ImageVector
    get() {
        if (_bedroomParent != null) {
            return _bedroomParent!!
        }
        _bedroomParent = materialIcon(name = "TwoTone.BedroomParent") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 20.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(5.0f, 13.17f)
                curveToRelative(0.0f, -0.66f, 0.25f, -1.26f, 0.65f, -1.72f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineTo(11.0f)
                curveToRelative(0.37f, 0.0f, 0.72f, 0.12f, 1.0f, 0.32f)
                curveTo(12.28f, 7.12f, 12.63f, 7.0f, 13.0f, 7.0f)
                horizontalLineToRelative(3.35f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(2.45f)
                curveToRelative(0.4f, 0.46f, 0.65f, 1.06f, 0.65f, 1.72f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-11.0f)
                verticalLineTo(17.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(13.17f)
                close()
            }
            materialPath {
                moveTo(20.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 2.0f, 2.0f, 2.9f, 2.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(22.0f, 2.9f, 21.1f, 2.0f, 20.0f, 2.0f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(20.0f)
                close()
            }
            materialPath {
                moveTo(6.5f, 15.5f)
                horizontalLineToRelative(11.0f)
                verticalLineTo(17.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(-3.83f)
                curveToRelative(0.0f, -0.66f, -0.25f, -1.26f, -0.65f, -1.72f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(13.0f)
                curveToRelative(-0.37f, 0.0f, -0.72f, 0.12f, -1.0f, 0.32f)
                curveTo(11.72f, 7.12f, 11.37f, 7.0f, 11.0f, 7.0f)
                horizontalLineTo(7.65f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(2.45f)
                curveTo(5.25f, 11.91f, 5.0f, 12.51f, 5.0f, 13.17f)
                verticalLineTo(17.0f)
                horizontalLineToRelative(1.5f)
                verticalLineTo(15.5f)
                close()
                moveTo(12.75f, 8.5f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(8.5f)
                close()
                moveTo(7.25f, 8.5f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(8.5f)
                close()
                moveTo(6.5f, 13.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(9.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-11.0f)
                verticalLineTo(13.0f)
                close()
            }
        }
        return _bedroomParent!!
    }

private var _bedroomParent: ImageVector? = null
