/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AppRegistration: ImageVector
    get() {
        if (_appRegistration != null) {
            return _appRegistration!!
        }
        _appRegistration = materialIcon(name = "TwoTone.AppRegistration") {
            materialPath {
                moveTo(10.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 16.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 10.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(4.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 4.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 17.86f)
                lineToRelative(0.0f, 2.14f)
                lineToRelative(2.1f, 0.0f)
                lineToRelative(5.98f, -5.97f)
                lineToRelative(-2.12f, -2.12f)
                close()
            }
            materialPath {
                moveTo(14.0f, 12.03f)
                lineToRelative(0.0f, -2.03f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(2.03f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.85f, 11.56f)
                lineToRelative(-1.41f, -1.41f)
                curveToRelative(-0.2f, -0.2f, -0.51f, -0.2f, -0.71f, 0.0f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(1.06f, -1.06f)
                curveTo(21.05f, 12.07f, 21.05f, 11.76f, 20.85f, 11.56f)
                close()
            }
        }
        return _appRegistration!!
    }

private var _appRegistration: ImageVector? = null
