/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Sledding: ImageVector
    get() {
        if (_sledding != null) {
            return _sledding!!
        }
        _sledding = materialIcon(name = "Sharp.Sledding") {
            materialPath {
                moveTo(14.0f, 4.5f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveTo(14.0f, 3.4f, 14.0f, 4.5f)
                close()
                moveTo(17.22f, 17.9f)
                lineToRelative(1.93f, 0.63f)
                lineToRelative(-0.46f, 1.43f)
                lineToRelative(-3.32f, -1.08f)
                lineTo(14.9f, 20.3f)
                lineToRelative(3.32f, 1.08f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(1.31f, 0.43f, 2.72f, -0.29f, 3.15f, -1.61f)
                curveToRelative(0.43f, -1.31f, -0.29f, -2.72f, -1.61f, -3.15f)
                lineToRelative(0.46f, -1.43f)
                curveToRelative(2.1f, 0.68f, 3.25f, 2.94f, 2.57f, 5.04f)
                curveToRelative(-0.68f, 2.1f, -2.94f, 3.25f, -5.04f, 2.57f)
                horizontalLineToRelative(0.0f)
                lineTo(1.0f, 17.36f)
                lineToRelative(0.46f, -1.43f)
                lineToRelative(3.93f, 1.28f)
                lineToRelative(0.46f, -1.43f)
                lineTo(1.93f, 14.5f)
                lineToRelative(0.46f, -1.43f)
                lineTo(4.0f, 13.6f)
                verticalLineTo(9.5f)
                lineToRelative(5.47f, -2.35f)
                curveToRelative(0.39f, -0.17f, 0.84f, -0.21f, 1.28f, -0.07f)
                curveToRelative(0.95f, 0.31f, 1.46f, 1.32f, 1.16f, 2.27f)
                lineToRelative(-1.05f, 3.24f)
                lineTo(14.5f, 12.0f)
                lineTo(17.22f, 17.9f)
                close()
                moveTo(6.0f, 14.25f)
                lineToRelative(0.48f, 0.16f)
                lineToRelative(0.75f, -2.31f)
                lineTo(7.92f, 10.0f)
                lineTo(6.0f, 10.82f)
                verticalLineTo(14.25f)
                close()
                moveTo(13.94f, 18.41f)
                lineToRelative(-6.66f, -2.16f)
                lineToRelative(-0.46f, 1.43f)
                lineToRelative(6.66f, 2.16f)
                lineTo(13.94f, 18.41f)
                close()
                moveTo(14.63f, 17.05f)
                lineToRelative(-1.18f, -2.56f)
                lineToRelative(-3.97f, 0.89f)
                lineTo(14.63f, 17.05f)
                close()
            }
        }
        return _sledding!!
    }

private var _sledding: ImageVector? = null
