/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SignalWifiBad: ImageVector
    get() {
        if (_signalWifiBad != null) {
            return _signalWifiBad!!
        }
        _signalWifiBad = materialIcon(name = "Sharp.SignalWifiBad") {
            materialPath {
                moveTo(24.0f, 8.98f)
                curveTo(20.93f, 5.9f, 16.69f, 4.0f, 12.0f, 4.0f)
                curveTo(7.31f, 4.0f, 3.07f, 5.9f, 0.0f, 8.98f)
                lineTo(12.0f, 21.0f)
                verticalLineToRelative(-9.0f)
                horizontalLineToRelative(8.99f)
                lineTo(24.0f, 8.98f)
                close()
                moveTo(19.59f, 14.0f)
                lineToRelative(-2.09f, 2.09f)
                lineToRelative(-0.3f, -0.3f)
                lineTo(15.41f, 14.0f)
                lineTo(14.0f, 15.41f)
                lineToRelative(1.79f, 1.79f)
                lineToRelative(0.3f, 0.3f)
                lineTo(14.0f, 19.59f)
                lineTo(15.41f, 21.0f)
                lineToRelative(2.09f, -2.08f)
                lineTo(19.59f, 21.0f)
                lineTo(21.0f, 19.59f)
                lineToRelative(-2.08f, -2.09f)
                lineTo(21.0f, 15.41f)
                lineTo(19.59f, 14.0f)
                close()
            }
        }
        return _signalWifiBad!!
    }

private var _signalWifiBad: ImageVector? = null
