/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PhoneDisabled: ImageVector
    get() {
        if (_phoneDisabled != null) {
            return _phoneDisabled!!
        }
        _phoneDisabled = materialIcon(name = "Sharp.PhoneDisabled") {
            materialPath {
                moveTo(14.52f, 17.35f)
                curveTo(11.39f, 19.83f, 7.36f, 21.22f, 3.0f, 20.97f)
                verticalLineToRelative(-5.51f)
                lineToRelative(5.27f, -0.61f)
                lineToRelative(2.52f, 2.52f)
                curveToRelative(0.81f, -0.41f, 1.58f, -0.9f, 2.3f, -1.45f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.42f, -1.41f)
                lineTo(21.19f, 21.2f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(14.52f, 17.35f)
                close()
                moveTo(15.91f, 13.11f)
                curveToRelative(0.56f, -0.73f, 1.05f, -1.51f, 1.47f, -2.33f)
                lineToRelative(-2.53f, -2.53f)
                lineTo(15.46f, 3.0f)
                horizontalLineToRelative(5.51f)
                curveToRelative(0.25f, 4.37f, -1.15f, 8.4f, -3.63f, 11.54f)
                lineTo(15.91f, 13.11f)
                close()
            }
        }
        return _phoneDisabled!!
    }

private var _phoneDisabled: ImageVector? = null
