/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WatchLater: ImageVector
    get() {
        if (_watchLater != null) {
            return _watchLater!!
        }
        _watchLater = materialIcon(name = "Rounded.WatchLater") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.5f, 2.0f, 2.0f, 6.5f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.5f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.5f, 10.0f, -10.0f)
                reflectiveCurveTo(17.5f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(15.55f, 15.8f)
                lineToRelative(-4.08f, -2.51f)
                curveToRelative(-0.3f, -0.18f, -0.48f, -0.5f, -0.48f, -0.85f)
                verticalLineTo(7.75f)
                curveTo(11.0f, 7.34f, 11.34f, 7.0f, 11.75f, 7.0f)
                reflectiveCurveToRelative(0.75f, 0.34f, 0.75f, 0.75f)
                verticalLineToRelative(4.45f)
                lineToRelative(3.84f, 2.31f)
                curveToRelative(0.36f, 0.22f, 0.48f, 0.69f, 0.26f, 1.05f)
                curveTo(16.38f, 15.91f, 15.91f, 16.02f, 15.55f, 15.8f)
                close()
            }
        }
        return _watchLater!!
    }

private var _watchLater: ImageVector? = null
