/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SwipeUp: ImageVector
    get() {
        if (_swipeUp != null) {
            return _swipeUp!!
        }
        _swipeUp = materialIcon(name = "Rounded.SwipeUp") {
            materialPath {
                moveTo(8.83f, 19.1f)
                curveToRelative(-0.26f, -0.6f, 0.09f, -1.28f, 0.73f, -1.41f)
                lineToRelative(3.58f, -0.71f)
                lineTo(8.79f, 7.17f)
                curveToRelative(-0.34f, -0.76f, 0.0f, -1.64f, 0.76f, -1.98f)
                curveToRelative(0.76f, -0.34f, 1.64f, 0.0f, 1.98f, 0.76f)
                lineToRelative(2.43f, 5.49f)
                lineToRelative(0.84f, -0.37f)
                curveToRelative(0.28f, -0.13f, 0.59f, -0.18f, 0.9f, -0.17f)
                lineToRelative(4.56f, 0.21f)
                curveToRelative(0.86f, 0.04f, 1.6f, 0.63f, 1.83f, 1.45f)
                lineToRelative(1.23f, 4.33f)
                curveToRelative(0.27f, 0.96f, -0.2f, 1.97f, -1.11f, 2.37f)
                lineToRelative(-5.63f, 2.49f)
                curveToRelative(-0.48f, 0.21f, -1.26f, 0.33f, -1.76f, 0.14f)
                lineToRelative(-5.45f, -2.27f)
                curveTo(9.13f, 19.53f, 8.93f, 19.34f, 8.83f, 19.1f)
                close()
                moveTo(6.75f, 13.38f)
                curveToRelative(0.26f, -0.26f, 0.29f, -0.66f, 0.09f, -0.95f)
                curveTo(5.68f, 10.74f, 5.0f, 8.7f, 5.0f, 6.5f)
                curveToRelative(0.0f, -0.88f, 0.11f, -1.74f, 0.32f, -2.56f)
                lineToRelative(1.09f, 1.09f)
                curveToRelative(0.3f, 0.3f, 0.79f, 0.29f, 1.08f, -0.02f)
                curveToRelative(0.28f, -0.3f, 0.25f, -0.78f, -0.04f, -1.07f)
                lineTo(5.21f, 1.71f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(1.53f, 3.97f)
                curveToRelative(-0.3f, 0.3f, -0.29f, 0.79f, 0.02f, 1.08f)
                curveToRelative(0.3f, 0.28f, 0.78f, 0.25f, 1.07f, -0.04f)
                lineTo(3.8f, 3.82f)
                curveTo(3.6f, 4.68f, 3.5f, 5.58f, 3.5f, 6.5f)
                curveToRelative(0.0f, 2.51f, 0.77f, 4.85f, 2.09f, 6.77f)
                curveTo(5.86f, 13.66f, 6.41f, 13.72f, 6.75f, 13.38f)
                close()
            }
        }
        return _swipeUp!!
    }

private var _swipeUp: ImageVector? = null
