/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SpatialAudio: ImageVector
    get() {
        if (_spatialAudio != null) {
            return _spatialAudio!!
        }
        _spatialAudio = materialIcon(name = "Rounded.SpatialAudio") {
            materialPath {
                moveTo(22.11f, 7.95f)
                curveToRelative(-1.89f, -0.23f, -5.57f, -1.83f, -6.09f, -6.09f)
                curveTo(15.96f, 1.36f, 15.54f, 1.0f, 15.04f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.6f, 0.0f, -1.07f, 0.53f, -1.0f, 1.13f)
                curveToRelative(0.31f, 2.43f, 2.38f, 7.12f, 7.8f, 7.8f)
                curveToRelative(0.6f, 0.08f, 1.13f, -0.4f, 1.13f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(22.97f, 8.43f, 22.6f, 8.01f, 22.11f, 7.95f)
                close()
            }
            materialPath {
                moveTo(21.71f, 5.83f)
                curveToRelative(0.64f, 0.17f, 1.26f, -0.31f, 1.26f, -0.97f)
                curveToRelative(0.0f, -0.47f, -0.34f, -0.85f, -0.79f, -0.97f)
                curveToRelative(-0.49f, -0.14f, -1.72f, -0.68f, -2.11f, -2.13f)
                curveTo(19.95f, 1.32f, 19.57f, 1.0f, 19.11f, 1.0f)
                horizontalLineTo(19.1f)
                curveToRelative(-0.66f, 0.0f, -1.14f, 0.64f, -0.96f, 1.28f)
                curveTo(18.74f, 4.5f, 20.58f, 5.53f, 21.71f, 5.83f)
                close()
            }
            materialPath {
                moveTo(10.0f, 9.0f)
                moveToRelative(-4.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, 8.0f, 0.0f)
                arcToRelative(4.0f, 4.0f, 0.0f, true, true, -8.0f, 0.0f)
            }
            materialPath {
                moveTo(16.39f, 15.56f)
                curveTo(14.71f, 14.7f, 12.53f, 14.0f, 10.0f, 14.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(2.61f, 16.07f, 2.0f, 17.1f, 2.0f, 18.22f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-2.78f)
                curveTo(18.0f, 17.1f, 17.39f, 16.07f, 16.39f, 15.56f)
                close()
            }
        }
        return _spatialAudio!!
    }

private var _spatialAudio: ImageVector? = null
