/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalCellularNodata: ImageVector
    get() {
        if (_signalCellularNodata != null) {
            return _signalCellularNodata!!
        }
        _signalCellularNodata = materialIcon(name = "Rounded.SignalCellularNodata") {
            materialPath {
                moveTo(22.0f, 13.0f)
                horizontalLineToRelative(-7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(4.41f)
                curveToRelative(-0.89f, 0.0f, -1.34f, -1.08f, -0.71f, -1.71f)
                lineTo(20.29f, 3.71f)
                curveTo(20.92f, 3.08f, 22.0f, 3.52f, 22.0f, 4.41f)
                verticalLineTo(13.0f)
                close()
                moveTo(20.3f, 14.71f)
                lineTo(20.3f, 14.71f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-1.39f, 1.39f)
                lineToRelative(-1.39f, -1.39f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(1.39f, 1.39f)
                lineToRelative(-1.39f, 1.39f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(1.39f, -1.38f)
                lineToRelative(1.39f, 1.38f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-1.38f, -1.39f)
                lineToRelative(1.38f, -1.39f)
                curveTo(20.69f, 15.73f, 20.69f, 15.1f, 20.3f, 14.71f)
                close()
            }
        }
        return _signalCellularNodata!!
    }

private var _signalCellularNodata: ImageVector? = null
