/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.OutdoorGrill: ImageVector
    get() {
        if (_outdoorGrill != null) {
            return _outdoorGrill!!
        }
        _outdoorGrill = materialIcon(name = "Rounded.OutdoorGrill") {
            materialPath {
                moveTo(17.0f, 22.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                curveToRelative(-1.3f, 0.0f, -2.4f, 0.84f, -2.82f, 2.0f)
                horizontalLineTo(9.14f)
                lineToRelative(1.99f, -3.06f)
                curveTo(11.42f, 14.98f, 11.71f, 15.0f, 12.0f, 15.0f)
                reflectiveCurveToRelative(0.58f, -0.02f, 0.87f, -0.06f)
                lineToRelative(1.02f, 1.57f)
                curveToRelative(0.42f, -0.53f, 0.96f, -0.95f, 1.6f, -1.21f)
                lineToRelative(-0.6f, -0.93f)
                curveToRelative(2.1f, -0.95f, 3.64f, -2.9f, 4.02f, -5.24f)
                curveTo(19.01f, 8.54f, 18.52f, 8.0f, 17.92f, 8.0f)
                curveTo(15.31f, 8.0f, 8.69f, 8.0f, 6.08f, 8.0f)
                curveTo(5.48f, 8.0f, 4.99f, 8.54f, 5.09f, 9.14f)
                curveToRelative(0.38f, 2.34f, 1.93f, 4.29f, 4.02f, 5.24f)
                lineToRelative(-3.95f, 6.08f)
                curveToRelative(-0.3f, 0.46f, -0.17f, 1.08f, 0.29f, 1.38f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.46f, 0.3f, 1.08f, 0.17f, 1.38f, -0.29f)
                lineToRelative(1.0f, -1.55f)
                horizontalLineToRelative(6.34f)
                curveTo(14.6f, 21.16f, 15.7f, 22.0f, 17.0f, 22.0f)
                close()
                moveTo(17.0f, 18.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                curveTo(16.0f, 18.45f, 16.45f, 18.0f, 17.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(9.5f, 6.47f)
                curveTo(9.48f, 6.75f, 9.68f, 7.0f, 9.96f, 7.0f)
                horizontalLineTo(10.0f)
                curveToRelative(0.24f, 0.0f, 0.44f, -0.18f, 0.46f, -0.42f)
                curveToRelative(0.1f, -0.87f, 0.04f, -1.39f, -0.94f, -2.54f)
                curveTo(9.16f, 3.61f, 8.92f, 3.35f, 8.99f, 2.49f)
                curveTo(9.02f, 2.23f, 8.8f, 2.0f, 8.53f, 2.0f)
                horizontalLineTo(8.48f)
                curveTo(8.24f, 2.0f, 8.03f, 2.19f, 8.01f, 2.43f)
                curveToRelative(-0.08f, 0.93f, 0.2f, 1.74f, 0.95f, 2.53f)
                curveTo(9.15f, 5.17f, 9.6f, 5.52f, 9.5f, 6.47f)
                close()
            }
            materialPath {
                moveTo(11.99f, 6.47f)
                curveTo(11.96f, 6.75f, 12.17f, 7.0f, 12.45f, 7.0f)
                horizontalLineToRelative(0.03f)
                curveToRelative(0.24f, 0.0f, 0.44f, -0.18f, 0.46f, -0.42f)
                curveToRelative(0.1f, -0.87f, 0.04f, -1.39f, -0.94f, -2.54f)
                curveToRelative(-0.36f, -0.43f, -0.61f, -0.69f, -0.53f, -1.55f)
                curveTo(11.5f, 2.23f, 11.28f, 2.0f, 11.01f, 2.0f)
                horizontalLineToRelative(-0.05f)
                curveToRelative(-0.24f, 0.0f, -0.45f, 0.19f, -0.47f, 0.43f)
                curveToRelative(-0.08f, 0.93f, 0.2f, 1.74f, 0.95f, 2.53f)
                curveTo(11.63f, 5.17f, 12.08f, 5.52f, 11.99f, 6.47f)
                close()
            }
            materialPath {
                moveTo(14.5f, 6.47f)
                curveTo(14.48f, 6.75f, 14.68f, 7.0f, 14.96f, 7.0f)
                horizontalLineTo(15.0f)
                curveToRelative(0.24f, 0.0f, 0.44f, -0.18f, 0.46f, -0.42f)
                curveToRelative(0.1f, -0.87f, 0.04f, -1.39f, -0.94f, -2.54f)
                curveToRelative(-0.36f, -0.43f, -0.61f, -0.69f, -0.53f, -1.55f)
                curveTo(14.02f, 2.23f, 13.8f, 2.0f, 13.53f, 2.0f)
                horizontalLineToRelative(-0.05f)
                curveToRelative(-0.24f, 0.0f, -0.45f, 0.19f, -0.47f, 0.43f)
                curveToRelative(-0.08f, 0.93f, 0.2f, 1.74f, 0.95f, 2.53f)
                curveTo(14.15f, 5.17f, 14.6f, 5.52f, 14.5f, 6.47f)
                close()
            }
        }
        return _outdoorGrill!!
    }

private var _outdoorGrill: ImageVector? = null
