/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.KingBed: ImageVector
    get() {
        if (_kingBed != null) {
            return _kingBed!!
        }
        _kingBed = materialIcon(name = "Rounded.KingBed") {
            materialPath {
                moveTo(20.0f, 10.0f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 5.0f, 4.0f, 5.9f, 4.0f, 7.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(1.33f)
                lineToRelative(0.51f, 1.53f)
                curveTo(3.94f, 18.81f, 4.2f, 19.0f, 4.5f, 19.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.3f, 0.0f, 0.56f, -0.19f, 0.66f, -0.47f)
                lineTo(5.67f, 17.0f)
                horizontalLineToRelative(12.67f)
                lineToRelative(0.51f, 1.53f)
                curveTo(18.94f, 18.81f, 19.2f, 19.0f, 19.5f, 19.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.3f, 0.0f, 0.56f, -0.19f, 0.66f, -0.47f)
                lineTo(20.67f, 17.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-5.0f)
                curveTo(22.0f, 10.9f, 21.1f, 10.0f, 20.0f, 10.0f)
                close()
                moveTo(11.0f, 10.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(18.0f, 10.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(10.0f)
                close()
            }
        }
        return _kingBed!!
    }

private var _kingBed: ImageVector? = null
