/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Kayaking: ImageVector
    get() {
        if (_kayaking != null) {
            return _kayaking!!
        }
        _kayaking = materialIcon(name = "Rounded.Kayaking") {
            materialPath {
                moveTo(2.0f, 22.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.87f, 0.0f, 1.73f, -0.24f, 2.53f, -0.7f)
                curveToRelative(0.29f, -0.16f, 0.65f, -0.17f, 0.94f, 0.0f)
                curveToRelative(1.59f, 0.9f, 3.48f, 0.9f, 5.06f, 0.0f)
                curveToRelative(0.29f, -0.16f, 0.65f, -0.16f, 0.94f, 0.0f)
                curveToRelative(1.59f, 0.9f, 3.48f, 0.9f, 5.06f, 0.0f)
                curveToRelative(0.29f, -0.16f, 0.65f, -0.16f, 0.94f, 0.0f)
                curveTo(19.27f, 20.76f, 20.13f, 21.0f, 21.0f, 21.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-1.03f, 0.0f, -2.06f, -0.25f, -3.0f, -0.75f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-1.92f, 1.02f, -4.18f, 1.0f, -6.09f, -0.05f)
                curveToRelative(-1.79f, 0.87f, -3.92f, 0.98f, -5.58f, -0.14f)
                curveTo(5.3f, 22.69f, 4.15f, 23.0f, 3.0f, 23.0f)
                horizontalLineToRelative(0.0f)
                curveTo(2.45f, 23.0f, 2.0f, 22.55f, 2.0f, 22.0f)
                close()
                moveTo(12.0f, 5.5f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(13.1f, 5.5f, 12.0f, 5.5f)
                close()
                moveTo(21.47f, 18.45f)
                curveToRelative(-0.42f, 0.14f, -0.9f, 0.28f, -1.41f, 0.42f)
                curveToRelative(-0.53f, -0.15f, -1.03f, -0.43f, -1.45f, -0.77f)
                curveToRelative(-0.35f, -0.29f, -0.87f, -0.29f, -1.23f, 0.0f)
                curveTo(16.72f, 18.63f, 15.9f, 19.0f, 15.0f, 19.0f)
                reflectiveCurveToRelative(-1.72f, -0.37f, -2.39f, -0.91f)
                curveToRelative(-0.35f, -0.28f, -0.87f, -0.28f, -1.22f, 0.0f)
                curveTo(10.72f, 18.63f, 9.9f, 19.0f, 9.0f, 19.0f)
                reflectiveCurveToRelative(-1.72f, -0.37f, -2.39f, -0.91f)
                curveToRelative(-0.35f, -0.29f, -0.87f, -0.28f, -1.23f, 0.0f)
                curveToRelative(-0.43f, 0.35f, -0.92f, 0.62f, -1.45f, 0.77f)
                curveToRelative(-0.51f, -0.14f, -0.98f, -0.28f, -1.4f, -0.42f)
                curveToRelative(-0.92f, -0.3f, -0.92f, -1.6f, 0.0f, -1.9f)
                curveToRelative(1.21f, -0.39f, 2.79f, -0.82f, 4.6f, -1.13f)
                lineToRelative(1.35f, -4.17f)
                curveToRelative(0.31f, -0.95f, 1.32f, -1.47f, 2.27f, -1.16f)
                curveToRelative(0.09f, 0.03f, 0.19f, 0.07f, 0.27f, 0.11f)
                lineToRelative(0.0f, 0.0f)
                lineToRelative(2.47f, 1.3f)
                lineToRelative(2.84f, -1.5f)
                lineToRelative(1.65f, -3.71f)
                lineToRelative(-0.36f, -0.93f)
                curveToRelative(-0.1f, -0.25f, -0.09f, -0.52f, 0.02f, -0.76f)
                lineToRelative(0.74f, -1.68f)
                curveToRelative(0.22f, -0.51f, 0.82f, -0.73f, 1.32f, -0.51f)
                lineToRelative(1.37f, 0.61f)
                curveToRelative(0.5f, 0.23f, 0.73f, 0.82f, 0.5f, 1.32f)
                lineToRelative(-0.75f, 1.68f)
                curveToRelative(-0.11f, 0.24f, -0.31f, 0.43f, -0.56f, 0.53f)
                lineTo(19.36f, 6.9f)
                lineToRelative(-3.72f, 8.34f)
                curveToRelative(2.33f, 0.3f, 4.35f, 0.84f, 5.82f, 1.31f)
                curveTo(22.39f, 16.85f, 22.4f, 18.15f, 21.47f, 18.45f)
                close()
                moveTo(15.02f, 12.96f)
                lineToRelative(-0.59f, 0.31f)
                curveToRelative(-0.58f, 0.31f, -1.28f, 0.31f, -1.86f, 0.0f)
                lineToRelative(-0.81f, -0.43f)
                lineToRelative(-0.71f, 2.17f)
                curveTo(11.36f, 15.01f, 11.68f, 15.0f, 12.0f, 15.0f)
                curveToRelative(0.71f, 0.0f, 1.4f, 0.03f, 2.07f, 0.08f)
                lineTo(15.02f, 12.96f)
                close()
            }
        }
        return _kayaking!!
    }

private var _kayaking: ImageVector? = null
