/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.DeveloperBoardOff: ImageVector
    get() {
        if (_developerBoardOff != null) {
            return _developerBoardOff!!
        }
        _developerBoardOff = materialIcon(name = "Rounded.DeveloperBoardOff") {
            materialPath {
                moveTo(7.83f, 5.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(10.17f)
                lineTo(19.83f, 17.0f)
                horizontalLineTo(21.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.83f)
                lineTo(7.83f, 5.0f)
                close()
                moveTo(15.0f, 10.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.06f, 0.0f, -0.13f, -0.01f, -0.19f, -0.02f)
                lineToRelative(-0.79f, -0.79f)
                curveTo(12.01f, 9.13f, 12.0f, 9.06f, 12.0f, 9.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                curveTo(16.0f, 9.55f, 15.55f, 10.0f, 15.0f, 10.0f)
                close()
                moveTo(11.0f, 8.0f)
                verticalLineToRelative(0.17f)
                lineTo(9.83f, 7.0f)
                horizontalLineTo(10.0f)
                curveTo(10.55f, 7.0f, 11.0f, 7.45f, 11.0f, 8.0f)
                close()
                moveTo(16.0f, 12.0f)
                verticalLineToRelative(1.17f)
                lineTo(13.83f, 11.0f)
                horizontalLineTo(15.0f)
                curveTo(15.55f, 11.0f, 16.0f, 11.45f, 16.0f, 12.0f)
                close()
                moveTo(1.39f, 2.81f)
                lineTo(1.39f, 2.81f)
                curveTo(1.0f, 3.2f, 1.0f, 3.83f, 1.39f, 4.22f)
                lineToRelative(0.61f, 0.61f)
                curveTo(2.0f, 4.89f, 2.0f, 4.94f, 2.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.06f, 0.0f, 0.11f, 0.0f, 0.16f, -0.01f)
                lineToRelative(1.61f, 1.61f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(2.81f, 2.81f)
                curveTo(2.42f, 2.42f, 1.78f, 2.42f, 1.39f, 2.81f)
                close()
                moveTo(4.0f, 19.0f)
                verticalLineTo(6.83f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(11.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.17f)
                lineToRelative(1.02f, 1.02f)
                curveTo(10.13f, 13.01f, 10.06f, 13.0f, 10.0f, 13.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.06f, -0.01f, -0.13f, -0.02f, -0.19f)
                lineTo(12.0f, 14.83f)
                verticalLineToRelative(0.46f)
                verticalLineTo(16.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.38f)
                horizontalLineToRelative(0.8f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(4.0f)
                close()
            }
        }
        return _developerBoardOff!!
    }

private var _developerBoardOff: ImageVector? = null
