/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SyncDisabled: ImageVector
    get() {
        if (_syncDisabled != null) {
            return _syncDisabled!!
        }
        _syncDisabled = materialIcon(name = "Outlined.SyncDisabled") {
            materialPath {
                moveTo(10.0f, 6.35f)
                verticalLineTo(4.26f)
                curveToRelative(-0.66f, 0.17f, -1.29f, 0.43f, -1.88f, 0.75f)
                lineToRelative(1.5f, 1.5f)
                curveToRelative(0.13f, -0.05f, 0.25f, -0.11f, 0.38f, -0.16f)
                close()
                moveTo(20.0f, 12.0f)
                curveToRelative(0.0f, -2.21f, -0.91f, -4.2f, -2.36f, -5.64f)
                lineTo(20.0f, 4.0f)
                horizontalLineToRelative(-6.0f)
                verticalLineToRelative(6.0f)
                lineToRelative(2.24f, -2.24f)
                curveTo(17.32f, 8.85f, 18.0f, 10.34f, 18.0f, 12.0f)
                curveToRelative(0.0f, 0.85f, -0.19f, 1.65f, -0.51f, 2.38f)
                lineToRelative(1.5f, 1.5f)
                curveTo(19.63f, 14.74f, 20.0f, 13.41f, 20.0f, 12.0f)
                close()
                moveTo(4.27f, 4.0f)
                lineTo(2.86f, 5.41f)
                lineToRelative(2.36f, 2.36f)
                curveTo(4.45f, 8.99f, 4.0f, 10.44f, 4.0f, 12.0f)
                curveToRelative(0.0f, 2.21f, 0.91f, 4.2f, 2.36f, 5.64f)
                lineTo(4.0f, 20.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-6.0f)
                lineToRelative(-2.24f, 2.24f)
                curveTo(6.68f, 15.15f, 6.0f, 13.66f, 6.0f, 12.0f)
                curveToRelative(0.0f, -1.0f, 0.25f, -1.94f, 0.68f, -2.77f)
                lineToRelative(8.08f, 8.08f)
                curveToRelative(-0.25f, 0.13f, -0.5f, 0.24f, -0.76f, 0.34f)
                verticalLineToRelative(2.09f)
                curveToRelative(0.8f, -0.21f, 1.55f, -0.54f, 2.23f, -0.96f)
                lineToRelative(2.58f, 2.58f)
                lineToRelative(1.41f, -1.41f)
                lineTo(4.27f, 4.0f)
                close()
            }
        }
        return _syncDisabled!!
    }

private var _syncDisabled: ImageVector? = null
