/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NoiseAware: ImageVector
    get() {
        if (_noiseAware != null) {
            return _noiseAware!!
        }
        _noiseAware = materialIcon(name = "Outlined.NoiseAware") {
            materialPath {
                moveTo(16.0f, 15.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                curveToRelative(-0.43f, 0.0f, -0.81f, -0.27f, -0.95f, -0.68f)
                curveToRelative(-0.15f, -0.44f, -0.4f, -1.08f, -0.93f, -1.61f)
                lineToRelative(-1.36f, -1.36f)
                curveTo(9.28f, 11.87f, 9.0f, 11.19f, 9.0f, 10.5f)
                curveTo(9.0f, 9.12f, 10.12f, 8.0f, 11.5f, 8.0f)
                curveToRelative(1.21f, 0.0f, 2.22f, 0.86f, 2.45f, 2.0f)
                horizontalLineToRelative(2.02f)
                curveToRelative(-0.25f, -2.25f, -2.16f, -4.0f, -4.47f, -4.0f)
                curveTo(9.02f, 6.0f, 7.0f, 8.02f, 7.0f, 10.5f)
                curveToRelative(0.0f, 1.22f, 0.49f, 2.41f, 1.35f, 3.27f)
                lineToRelative(1.36f, 1.36f)
                curveToRelative(0.17f, 0.17f, 0.31f, 0.44f, 0.44f, 0.82f)
                curveTo(10.56f, 17.17f, 11.71f, 18.0f, 13.0f, 18.0f)
                curveTo(14.65f, 18.0f, 16.0f, 16.65f, 16.0f, 15.0f)
                close()
            }
            materialPath {
                moveTo(13.5f, 12.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(3.6f, 6.58f)
                lineToRelative(1.58f, 1.26f)
                curveToRelative(0.35f, -0.57f, 0.77f, -1.1f, 1.24f, -1.57f)
                lineTo(4.85f, 5.02f)
                curveTo(4.38f, 5.49f, 3.97f, 6.02f, 3.6f, 6.58f)
                close()
            }
            materialPath {
                moveTo(9.46f, 4.42f)
                lineTo(8.59f, 2.61f)
                curveToRelative(-0.63f, 0.23f, -1.24f, 0.52f, -1.8f, 0.87f)
                lineToRelative(0.87f, 1.81f)
                curveTo(8.22f, 4.93f, 8.82f, 4.64f, 9.46f, 4.42f)
                close()
            }
            materialPath {
                moveTo(4.49f, 9.26f)
                lineTo(2.53f, 8.81f)
                curveToRelative(-0.21f, 0.63f, -0.36f, 1.28f, -0.44f, 1.95f)
                lineToRelative(1.96f, 0.45f)
                curveTo(4.11f, 10.53f, 4.27f, 9.88f, 4.49f, 9.26f)
                close()
            }
            materialPath {
                moveTo(20.4f, 6.58f)
                curveToRelative(-0.36f, -0.56f, -0.78f, -1.09f, -1.25f, -1.56f)
                lineToRelative(-1.58f, 1.26f)
                curveToRelative(0.48f, 0.47f, 0.89f, 0.99f, 1.24f, 1.57f)
                lineTo(20.4f, 6.58f)
                close()
            }
            materialPath {
                moveTo(4.04f, 12.79f)
                lineToRelative(-1.96f, 0.45f)
                curveToRelative(0.08f, 0.67f, 0.23f, 1.33f, 0.44f, 1.95f)
                lineToRelative(1.97f, -0.45f)
                curveTo(4.27f, 14.12f, 4.11f, 13.47f, 4.04f, 12.79f)
                close()
            }
            materialPath {
                moveTo(17.21f, 3.48f)
                curveToRelative(-0.57f, -0.35f, -1.17f, -0.64f, -1.8f, -0.87f)
                lineToRelative(-0.87f, 1.81f)
                curveToRelative(0.64f, 0.22f, 1.24f, 0.51f, 1.8f, 0.87f)
                lineTo(17.21f, 3.48f)
                close()
            }
            materialPath {
                moveTo(13.0f, 4.07f)
                verticalLineTo(2.05f)
                curveTo(12.67f, 2.02f, 12.34f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveToRelative(-0.67f, 0.02f, -1.0f, 0.05f)
                verticalLineToRelative(2.02f)
                curveTo(11.33f, 4.03f, 11.66f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(12.67f, 4.03f, 13.0f, 4.07f)
                close()
            }
            materialPath {
                moveTo(11.0f, 19.93f)
                verticalLineToRelative(2.02f)
                curveToRelative(0.33f, 0.03f, 0.66f, 0.05f, 1.0f, 0.05f)
                reflectiveCurveToRelative(0.67f, -0.02f, 1.0f, -0.05f)
                verticalLineToRelative(-2.02f)
                curveTo(12.67f, 19.97f, 12.34f, 20.0f, 12.0f, 20.0f)
                reflectiveCurveTo(11.33f, 19.97f, 11.0f, 19.93f)
                close()
            }
            materialPath {
                moveTo(19.51f, 14.74f)
                lineToRelative(1.97f, 0.45f)
                curveToRelative(0.21f, -0.63f, 0.36f, -1.28f, 0.44f, -1.95f)
                lineToRelative(-1.96f, -0.45f)
                curveTo(19.89f, 13.47f, 19.73f, 14.12f, 19.51f, 14.74f)
                close()
            }
            materialPath {
                moveTo(19.96f, 11.21f)
                lineToRelative(1.96f, -0.45f)
                curveToRelative(-0.08f, -0.67f, -0.23f, -1.33f, -0.44f, -1.95f)
                lineToRelative(-1.97f, 0.45f)
                curveTo(19.73f, 9.88f, 19.89f, 10.53f, 19.96f, 11.21f)
                close()
            }
            materialPath {
                moveTo(17.58f, 17.73f)
                lineToRelative(1.58f, 1.26f)
                curveToRelative(0.47f, -0.48f, 0.88f, -1.0f, 1.25f, -1.56f)
                lineToRelative(-1.58f, -1.26f)
                curveTo(18.47f, 16.73f, 18.05f, 17.26f, 17.58f, 17.73f)
                close()
            }
            materialPath {
                moveTo(6.79f, 20.52f)
                curveToRelative(0.57f, 0.35f, 1.17f, 0.64f, 1.8f, 0.87f)
                lineToRelative(0.87f, -1.81f)
                curveToRelative(-0.64f, -0.22f, -1.24f, -0.51f, -1.8f, -0.87f)
                lineTo(6.79f, 20.52f)
                close()
            }
            materialPath {
                moveTo(14.54f, 19.58f)
                lineToRelative(0.87f, 1.81f)
                curveToRelative(0.63f, -0.23f, 1.24f, -0.52f, 1.8f, -0.87f)
                lineToRelative(-0.87f, -1.81f)
                curveTo(15.78f, 19.07f, 15.18f, 19.36f, 14.54f, 19.58f)
                close()
            }
            materialPath {
                moveTo(3.6f, 17.42f)
                curveToRelative(0.36f, 0.56f, 0.78f, 1.09f, 1.25f, 1.56f)
                lineToRelative(1.58f, -1.26f)
                curveToRelative(-0.48f, -0.47f, -0.89f, -0.99f, -1.24f, -1.57f)
                lineTo(3.6f, 17.42f)
                close()
            }
        }
        return _noiseAware!!
    }

private var _noiseAware: ImageVector? = null
