/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.EnergySavingsLeaf: ImageVector
    get() {
        if (_energySavingsLeaf != null) {
            return _energySavingsLeaf!!
        }
        _energySavingsLeaf = materialIcon(name = "Outlined.EnergySavingsLeaf") {
            materialPath {
                moveTo(12.0f, 3.0f)
                curveTo(12.0f, 3.0f, 12.0f, 3.0f, 12.0f, 3.0f)
                curveToRelative(-4.8f, 0.0f, -9.0f, 3.86f, -9.0f, 9.0f)
                curveToRelative(0.0f, 2.12f, 0.74f, 4.07f, 1.97f, 5.61f)
                lineTo(3.0f, 19.59f)
                lineTo(4.41f, 21.0f)
                lineToRelative(1.97f, -1.97f)
                curveTo(7.93f, 20.26f, 9.88f, 21.0f, 12.0f, 21.0f)
                curveToRelative(2.3f, 0.0f, 4.61f, -0.88f, 6.36f, -2.64f)
                curveTo(20.12f, 16.61f, 21.0f, 14.3f, 21.0f, 12.0f)
                lineToRelative(0.0f, -9.0f)
                lineTo(12.0f, 3.0f)
                close()
                moveTo(19.0f, 12.0f)
                curveToRelative(0.0f, 1.87f, -0.73f, 3.63f, -2.05f, 4.95f)
                curveTo(15.63f, 18.27f, 13.87f, 19.0f, 12.0f, 19.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, -3.14f, -7.0f, -7.0f)
                curveToRelative(0.0f, -1.9f, 0.74f, -3.68f, 2.1f, -4.99f)
                curveTo(8.42f, 5.71f, 10.16f, 5.0f, 12.0f, 5.0f)
                lineToRelative(7.0f, 0.0f)
                lineTo(19.0f, 12.0f)
                close()
            }
            materialPath {
                moveTo(8.46f, 12.63f)
                lineToRelative(4.05f, 0.4f)
                lineToRelative(-2.44f, 3.33f)
                curveToRelative(-0.11f, 0.16f, -0.1f, 0.38f, 0.04f, 0.52f)
                curveToRelative(0.15f, 0.15f, 0.4f, 0.16f, 0.56f, 0.01f)
                lineToRelative(5.16f, -4.63f)
                curveToRelative(0.33f, -0.3f, 0.15f, -0.85f, -0.3f, -0.89f)
                lineToRelative(-4.05f, -0.4f)
                lineToRelative(2.44f, -3.33f)
                curveToRelative(0.11f, -0.16f, 0.1f, -0.38f, -0.04f, -0.52f)
                curveToRelative(-0.15f, -0.15f, -0.4f, -0.16f, -0.56f, -0.01f)
                lineToRelative(-5.16f, 4.63f)
                curveTo(7.84f, 12.04f, 8.02f, 12.59f, 8.46f, 12.63f)
                close()
            }
        }
        return _energySavingsLeaf!!
    }

private var _energySavingsLeaf: ImageVector? = null
