/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Flourescent: ImageVector
    get() {
        if (_flourescent != null) {
            return _flourescent!!
        }
        _flourescent = materialIcon(name = "Filled.Flourescent") {
            materialPath {
                moveTo(5.0f, 9.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-14.0f)
                close()
            }
            materialPath {
                moveTo(11.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.2864f, 6.3989f)
                lineToRelative(1.7897f, -1.8024f)
                lineToRelative(1.4192f, 1.4092f)
                lineToRelative(-1.7897f, 1.8024f)
                close()
            }
            materialPath {
                moveTo(11.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(17.29f, 17.71f)
                lineToRelative(1.79f, 1.8f)
                lineToRelative(1.42f, -1.42f)
                lineToRelative(-1.8f, -1.79f)
                close()
            }
            materialPath {
                moveTo(3.4947f, 6.0091f)
                lineToRelative(1.4071f, -1.4071f)
                lineToRelative(1.789f, 1.789f)
                lineToRelative(-1.4071f, 1.4071f)
                close()
            }
            materialPath {
                moveTo(3.4922f, 18.0762f)
                lineToRelative(1.8024f, -1.7897f)
                lineToRelative(1.4092f, 1.4192f)
                lineToRelative(-1.8024f, 1.7897f)
                close()
            }
        }
        return _flourescent!!
    }

private var _flourescent: ImageVector? = null
