/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.CurrencyLira: ImageVector
    get() {
        if (_currencyLira != null) {
            return _currencyLira!!
        }
        _currencyLira = materialIcon(name = "Filled.CurrencyLira") {
            materialPath {
                moveTo(9.0f, 8.76f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.51f)
                lineTo(15.0f, 5.0f)
                verticalLineToRelative(2.36f)
                lineToRelative(-4.0f, 2.51f)
                lineToRelative(0.01f, 2.35f)
                lineTo(15.0f, 9.72f)
                verticalLineToRelative(2.36f)
                lineToRelative(-4.0f, 2.51f)
                verticalLineTo(19.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, 3.87f, -3.13f, 7.0f, -7.0f, 7.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(-5.16f)
                lineToRelative(-3.0f, 1.88f)
                lineToRelative(0.0f, -2.36f)
                lineToRelative(3.0f, -1.88f)
                verticalLineToRelative(-2.36f)
                lineTo(6.0f, 13.0f)
                lineToRelative(0.0f, -2.36f)
                lineTo(9.0f, 8.76f)
                close()
            }
        }
        return _currencyLira!!
    }

private var _currencyLira: ImageVector? = null
