/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AutoFixOff: ImageVector
    get() {
        if (_autoFixOff != null) {
            return _autoFixOff!!
        }
        _autoFixOff = materialIcon(name = "TwoTone.AutoFixOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.417f, 18.174f)
                lineToRelative(5.466f, -5.466f)
                lineToRelative(1.414f, 1.414f)
                lineToRelative(-5.466f, 5.466f)
                close()
            }
            materialPath {
                moveTo(20.0f, 7.0f)
                lineToRelative(0.94f, -2.06f)
                lineToRelative(2.06f, -0.94f)
                lineToRelative(-2.06f, -0.94f)
                lineToRelative(-0.94f, -2.06f)
                lineToRelative(-0.94f, 2.06f)
                lineToRelative(-2.06f, 0.94f)
                lineToRelative(2.06f, 0.94f)
                close()
            }
            materialPath {
                moveTo(14.17f, 8.42f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(-1.46f, 1.46f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(2.17f, -2.17f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-2.83f, -2.83f)
                curveTo(14.68f, 6.1f, 14.43f, 6.0f, 14.17f, 6.0f)
                curveToRelative(-0.26f, 0.0f, -0.51f, 0.1f, -0.71f, 0.29f)
                lineToRelative(-2.17f, 2.17f)
                lineToRelative(1.41f, 1.41f)
                lineTo(14.17f, 8.42f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(7.07f, 7.07f)
                lineToRelative(-6.17f, 6.17f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.83f, 2.83f)
                curveTo(5.32f, 21.9f, 5.57f, 22.0f, 5.83f, 22.0f)
                reflectiveCurveToRelative(0.51f, -0.1f, 0.71f, -0.29f)
                lineToRelative(6.17f, -6.17f)
                lineToRelative(7.07f, 7.07f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(5.83f, 19.59f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(5.46f, -5.46f)
                lineToRelative(1.41f, 1.41f)
                lineTo(5.83f, 19.59f)
                close()
            }
        }
        return _autoFixOff!!
    }

private var _autoFixOff: ImageVector? = null
