/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TvOff: ImageVector
    get() {
        if (_tvOff != null) {
            return _tvOff!!
        }
        _tvOff = materialIcon(name = "Sharp.TvOff") {
            materialPath {
                moveTo(21.0f, 7.0f)
                verticalLineToRelative(10.88f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-9.58f)
                lineToRelative(3.29f, -3.3f)
                lineTo(16.0f, 1.0f)
                lineToRelative(-4.0f, 4.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-0.7f, 0.7f)
                lineTo(10.58f, 5.0f)
                horizontalLineTo(8.12f)
                lineToRelative(2.0f, 2.0f)
                close()
                moveTo(2.41f, 2.13f)
                lineToRelative(-0.14f, 0.14f)
                lineTo(1.0f, 3.54f)
                lineToRelative(1.53f, 1.53f)
                horizontalLineTo(1.0f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(17.46f)
                lineToRelative(1.99f, 1.99f)
                lineToRelative(1.26f, -1.26f)
                lineToRelative(0.15f, -0.15f)
                lineTo(2.41f, 2.13f)
                close()
                moveTo(3.0f, 19.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(1.46f)
                lineToRelative(12.0f, 12.0f)
                horizontalLineTo(3.0f)
                close()
            }
        }
        return _tvOff!!
    }

private var _tvOff: ImageVector? = null
